/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.ClassNameIdResolver;
import tools.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import tools.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    public XmlTypeResolverBuilder(JsonTypeInfo.Value typeInfo) {
        super(typeInfo);
    }

    protected String _propName(String propName, JsonTypeInfo.Id idType) {
        if (propName == null || propName.isEmpty()) {
            propName = StaxUtil.sanitizeXmlTypeName(idType.getDefaultPropertyName());
        } else if (propName.equals(idType.getDefaultPropertyName())) {
            propName = StaxUtil.sanitizeXmlTypeName(propName);
        }
        return propName;
    }

    protected TypeIdResolver idResolver(DatabindContext ctxt, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(baseType, this.subTypeValidator(ctxt));
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(baseType, this.subTypeValidator(ctxt));
            }
        }
        return super.idResolver(ctxt, baseType, subtypeValidator, subtypes, forSer, forDeser);
    }

    protected static String encodeXmlClassName(String className) {
        int ix = className.lastIndexOf(36);
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 1, "..");
            } while ((ix = className.lastIndexOf(36, ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static String decodeXmlClassName(String className) {
        int ix = className.lastIndexOf("..");
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 2, "$");
            } while ((ix = className.lastIndexOf("..", ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        private static final long serialVersionUID = 3L;

        public XmlClassNameIdResolver(JavaType baseType, PolymorphicTypeValidator ptv) {
            super(baseType, ptv);
        }

        public String idFromValue(DatabindContext ctxt, Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(ctxt, value));
        }

        public JavaType typeFromId(DatabindContext ctxt, String id) throws JacksonException {
            return super.typeFromId(ctxt, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        private static final long serialVersionUID = 3L;

        public XmlMinimalClassNameIdResolver(JavaType baseType, PolymorphicTypeValidator ptv) {
            super(baseType, ptv);
        }

        public String idFromValue(DatabindContext ctxt, Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(ctxt, value));
        }

        public JavaType typeFromId(DatabindContext ctxt, String id) throws JacksonException {
            return super.typeFromId(ctxt, XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }
}

