/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.smile;

import tools.jackson.core.FormatFeature;

public enum SmileWriteFeature implements FormatFeature
{
    WRITE_HEADER(true),
    WRITE_END_MARKER(false),
    ENCODE_BINARY_AS_7BIT(true),
    CHECK_SHARED_NAMES(true),
    CHECK_SHARED_STRING_VALUES(false),
    LENIENT_UTF_ENCODING(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (SmileWriteFeature f : SmileWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private SmileWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public int getMask() {
        return this._mask;
    }

    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }
}

