/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf;

import tools.jackson.core.TokenStreamContext;
import tools.jackson.dataformat.protobuf.schema.ProtobufField;
import tools.jackson.dataformat.protobuf.schema.ProtobufMessage;

public class ProtobufWriteContext
extends TokenStreamContext {
    protected final ProtobufWriteContext _parent;
    protected ProtobufMessage _message;
    protected ProtobufField _field;
    protected Object _currentValue;
    protected ProtobufWriteContext _child = null;

    protected ProtobufWriteContext(int type, ProtobufWriteContext parent, ProtobufMessage msg) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
        this._message = msg;
    }

    private void reset(int type, ProtobufMessage msg, ProtobufField f) {
        this._type = type;
        this._message = msg;
        this._field = f;
        this._currentValue = null;
    }

    public static ProtobufWriteContext createRootContext(ProtobufMessage msg) {
        return new ProtobufWriteContext(0, null, msg);
    }

    public static ProtobufWriteContext createNullContext() {
        return null;
    }

    public ProtobufWriteContext createChildArrayContext() {
        ProtobufWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new ProtobufWriteContext(1, this, this._message);
            ctxt._field = this._field;
            return ctxt;
        }
        ctxt.reset(1, this._message, this._field);
        return ctxt;
    }

    public ProtobufWriteContext createChildObjectContext(ProtobufMessage type) {
        ProtobufWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new ProtobufWriteContext(2, this, type);
            return ctxt;
        }
        ctxt.reset(2, type, null);
        return ctxt;
    }

    public final ProtobufWriteContext getParent() {
        return this._parent;
    }

    public String currentName() {
        return this._type == 2 && this._field != null ? this._field.name : null;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public void setField(ProtobufField f) {
        this._field = f;
    }

    public ProtobufField getField() {
        return this._field;
    }

    public ProtobufMessage getMessageType() {
        return this._message;
    }

    public boolean notArray() {
        return this._type != 1;
    }

    public StringBuilder appendDesc(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent.appendDesc(sb);
        }
        sb.append('/');
        switch (this._type) {
            case 2: {
                if (this._field == null) break;
                sb.append(this._field.name);
                break;
            }
            case 1: {
                sb.append(this.getCurrentIndex());
                break;
            }
        }
        return sb;
    }

    public final String toString() {
        return this.appendDesc(new StringBuilder(64)).toString();
    }
}

