/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schema;

import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import tools.jackson.dataformat.protobuf.schema.NativeProtobufSchema;
import tools.jackson.dataformat.protobuf.schema.ProtobufSchema;

public class ProtobufSchemaLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String DEFAULT_SCHEMA_NAME = "Unnamed-protobuf-schema";
    public static final ProtobufSchemaLoader std = new ProtobufSchemaLoader();

    public ProtobufSchema load(URL url) throws IOException {
        return this.loadNative(Objects.requireNonNull(url)).forFirstType();
    }

    public ProtobufSchema load(URL url, String rootTypeName) throws IOException {
        return this.loadNative(Objects.requireNonNull(url)).forType(rootTypeName);
    }

    public ProtobufSchema load(File f) throws IOException {
        return this.loadNative(Objects.requireNonNull(f)).forFirstType();
    }

    public ProtobufSchema load(File f, String rootTypeName) throws IOException {
        return this.loadNative(Objects.requireNonNull(f)).forType(rootTypeName);
    }

    public ProtobufSchema load(InputStream in) throws IOException {
        return this.loadNative(Objects.requireNonNull(in), true).forFirstType();
    }

    public ProtobufSchema load(InputStream in, String rootTypeName) throws IOException {
        return this.loadNative(Objects.requireNonNull(in), true).forType(rootTypeName);
    }

    public ProtobufSchema load(Reader r) throws IOException {
        return this.loadNative(Objects.requireNonNull(r), true).forFirstType();
    }

    public ProtobufSchema load(Reader r, String rootTypeName) throws IOException {
        return this.loadNative(Objects.requireNonNull(r), true).forType(rootTypeName);
    }

    public ProtobufSchema parse(String schemaAsString) throws IOException {
        return this.parseNative(schemaAsString).forFirstType();
    }

    public ProtobufSchema parse(String schemaAsString, String rootTypeName) throws IOException {
        return this.parseNative(schemaAsString).forType(rootTypeName);
    }

    public NativeProtobufSchema loadNative(File f) throws IOException {
        Objects.requireNonNull(f);
        return NativeProtobufSchema.construct(this._loadNative(f));
    }

    public NativeProtobufSchema loadNative(URL url) throws IOException {
        Objects.requireNonNull(url);
        return NativeProtobufSchema.construct(this._loadNative(url));
    }

    public NativeProtobufSchema parseNative(String schema) throws IOException {
        Objects.requireNonNull(schema);
        return NativeProtobufSchema.construct(this._loadNative(schema));
    }

    public NativeProtobufSchema loadNative(InputStream in, boolean close) throws IOException {
        Objects.requireNonNull(in);
        return NativeProtobufSchema.construct(this._loadNative(in, close));
    }

    protected NativeProtobufSchema loadNative(Reader r, boolean close) throws IOException {
        Objects.requireNonNull(r);
        return NativeProtobufSchema.construct(this._loadNative(r, close));
    }

    public ProtoFile _loadNative(File f) throws IOException {
        return ProtoParser.parseUtf8((File)f);
    }

    public ProtoFile _loadNative(URL url) throws IOException {
        return this._loadNative(url.openStream(), true);
    }

    public ProtoFile _loadNative(String schemaAsString) throws IOException {
        return ProtoParser.parse((String)DEFAULT_SCHEMA_NAME, (String)schemaAsString);
    }

    public ProtoFile _loadNative(InputStream in, boolean close) throws IOException {
        return this._loadNative(new InputStreamReader(in, UTF8), close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtoFile _loadNative(Reader r, boolean close) throws IOException {
        try {
            ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_SCHEMA_NAME, (String)this._readAll(r));
            return protoFile;
        }
        finally {
            if (close) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String _readAll(Reader r) throws IOException {
        int count;
        StringBuilder sb = new StringBuilder(1000);
        char[] buffer = new char[1000];
        while ((count = r.read(buffer)) > 0) {
            sb.append(buffer, 0, count);
        }
        return sb.toString();
    }
}

