/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.javaprop;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.javaprop.JavaPropsSchema;
import tools.jackson.dataformat.javaprop.PackageVersion;
import tools.jackson.dataformat.javaprop.io.JPropReadContext;
import tools.jackson.dataformat.javaprop.util.JPropNode;
import tools.jackson.dataformat.javaprop.util.JPropNodeBuilder;

public class JavaPropsParser
extends ParserMinimalBase {
    protected static final JavaPropsSchema DEFAULT_SCHEMA = new JavaPropsSchema();
    protected static final JacksonFeatureSet<StreamReadCapability> STREAM_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.UNTYPED_SCALARS);
    protected final Object _inputSource;
    protected final Map<?, ?> _sourceContent;
    protected JavaPropsSchema _schema = DEFAULT_SCHEMA;
    protected JPropReadContext _streamReadContext;
    protected ByteArrayBuilder _byteArrayBuilder;
    protected byte[] _binaryValue;

    public JavaPropsParser(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, JavaPropsSchema schema, Object inputSource, Map<?, ?> sourceMap) {
        super(readCtxt, ioCtxt, parserFeatures);
        this._inputSource = inputSource;
        this._sourceContent = sourceMap;
        this._schema = schema;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JavaPropsSchema getSchema() {
        return this._schema;
    }

    protected void _closeInput() throws IOException {
        this._streamReadContext = null;
    }

    protected void _releaseBuffers() {
    }

    public Object streamReadInputSource() {
        return this._inputSource;
    }

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return STREAM_READ_CAPABILITIES;
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public String currentName() {
        JPropReadContext parent;
        if (this._streamReadContext == null) {
            return null;
        }
        if ((this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) && (parent = this._streamReadContext.getParent()) != null) {
            return parent.currentName();
        }
        return this._streamReadContext.currentName();
    }

    public JsonToken nextToken() throws JacksonException {
        JsonToken t;
        this._binaryValue = null;
        if (this._streamReadContext == null) {
            if (this._closed) {
                return null;
            }
            JPropNode root = JPropNodeBuilder.build(this._sourceContent, this._schema);
            this._streamReadContext = JPropReadContext.create(root);
        }
        while ((t = this._streamReadContext.nextToken()) == null) {
            this._streamReadContext = this._streamReadContext.nextContext();
            if (this._streamReadContext == null) {
                return this._updateTokenToNull();
            }
            this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
        }
        return this._updateToken(t);
    }

    public String getString() throws JacksonException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            return this._streamReadContext.getCurrentText();
        }
        if (t == JsonToken.PROPERTY_NAME) {
            return this._streamReadContext.currentName();
        }
        return t == null ? null : t.asString();
    }

    public boolean hasStringCharacters() {
        return false;
    }

    public char[] getStringCharacters() throws JacksonException {
        String text = this.getString();
        return text == null ? null : text.toCharArray();
    }

    public int getStringLength() throws JacksonException {
        String text = this.getString();
        return text == null ? 0 : text.length();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public int getString(Writer writer) throws JacksonException {
        String str = this.getString();
        if (str == null) {
            return 0;
        }
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return str.length();
    }

    public byte[] getBinaryValue(Base64Variant variant) throws JacksonException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + String.valueOf(this._currToken) + ") not VALUE_STRING, cannot access as binary");
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getString(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    public Object getEmbeddedObject() throws JacksonException {
        return null;
    }

    public TokenStreamLocation currentTokenLocation() {
        return TokenStreamLocation.NA;
    }

    public TokenStreamLocation currentLocation() {
        return TokenStreamLocation.NA;
    }

    public Number getNumberValue() throws JacksonException {
        return (Number)this._noNumbers();
    }

    public JsonParser.NumberType getNumberType() throws JacksonException {
        return null;
    }

    public int getIntValue() throws JacksonException {
        return (Integer)this._noNumbers();
    }

    public long getLongValue() throws JacksonException {
        return (Long)this._noNumbers();
    }

    public BigInteger getBigIntegerValue() throws JacksonException {
        return (BigInteger)this._noNumbers();
    }

    public float getFloatValue() throws JacksonException {
        return ((Float)this._noNumbers()).floatValue();
    }

    public double getDoubleValue() throws JacksonException {
        return (Double)this._noNumbers();
    }

    public BigDecimal getDecimalValue() throws JacksonException {
        return (BigDecimal)this._noNumbers();
    }

    public boolean isNaN() {
        return false;
    }

    protected <T> T _noNumbers() throws StreamReadException {
        this._reportError("Current token (" + String.valueOf(this._currToken) + ") not numeric, cannot use numeric value accessors");
        return null;
    }

    protected void _handleEOF() throws StreamReadException {
        if (this._streamReadContext != null && !this._streamReadContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._streamReadContext.typeDesc(), null);
        }
    }
}

