/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv.impl;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import tools.jackson.core.JacksonException;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.dataformat.csv.CsvSchema;
import tools.jackson.dataformat.csv.CsvWriteException;
import tools.jackson.dataformat.csv.CsvWriteFeature;
import tools.jackson.dataformat.csv.impl.BufferedValue;

public class CsvEncoder {
    private static final int[] sOutputEscapes = new int[0];
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars((boolean)true);
    protected static final int SHORT_WRITE = 32;
    protected static final int MAX_QUOTE_CHECK = 24;
    protected final BufferedValue[] NO_BUFFERED = new BufferedValue[0];
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();
    protected int[] _outputEscapes = sOutputEscapes;
    protected final IOContext _ioContext;
    protected final Writer _out;
    protected final char _cfgColumnSeparator;
    protected final int _cfgQuoteCharacter;
    protected final int _cfgEscapeCharacter;
    protected final char[] _cfgLineSeparator;
    protected final char[] _cfgNullValue;
    protected final int _cfgLineSeparatorLength;
    protected final int _cfgMaxQuoteCheckChars;
    protected final int _cfgMinSafeChar;
    protected int _csvFeatures;
    protected boolean _cfgOptimalQuoting;
    protected final boolean _cfgAllowsComments;
    protected boolean _cfgIncludeMissingTail;
    protected boolean _cfgAlwaysQuoteStrings;
    protected boolean _cfgAlwaysQuoteEmptyStrings;
    protected boolean _cfgAlwaysQuoteNumbers;
    protected boolean _cfgEscapeQuoteCharWithEscapeChar;
    protected boolean _cfgEscapeControlCharWithEscapeChar;
    protected boolean _cfgUseFastDoubleWriter;
    protected final char _cfgQuoteCharEscapeChar;
    protected final char _cfgControlCharEscapeChar;
    protected int _columnCount;
    protected int _nextColumnToWrite = 0;
    protected BufferedValue[] _buffered = this.NO_BUFFERED;
    protected int _lastBuffered = -1;
    protected boolean _trailingLFRemoved = false;
    protected char[] _outputBuffer;
    protected boolean _bufferRecyclable;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _charsWritten;

    public CsvEncoder(IOContext ctxt, int csvFeatures, Writer out, CsvSchema schema, CharacterEscapes esc, boolean useFastDoubleWriter) {
        this._ioContext = ctxt;
        this._csvFeatures = csvFeatures;
        this._cfgUseFastDoubleWriter = useFastDoubleWriter;
        this._cfgOptimalQuoting = CsvWriteFeature.STRICT_CHECK_FOR_QUOTING.enabledIn(csvFeatures);
        this._cfgIncludeMissingTail = !CsvWriteFeature.OMIT_MISSING_TAIL_COLUMNS.enabledIn(this._csvFeatures);
        this._cfgAlwaysQuoteStrings = CsvWriteFeature.ALWAYS_QUOTE_STRINGS.enabledIn(csvFeatures);
        this._cfgAlwaysQuoteEmptyStrings = CsvWriteFeature.ALWAYS_QUOTE_EMPTY_STRINGS.enabledIn(csvFeatures);
        this._cfgAlwaysQuoteNumbers = CsvWriteFeature.ALWAYS_QUOTE_NUMBERS.enabledIn(csvFeatures);
        this._cfgEscapeQuoteCharWithEscapeChar = CsvWriteFeature.ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR.enabledIn(csvFeatures);
        this._cfgEscapeControlCharWithEscapeChar = CsvWriteFeature.ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR.enabledIn(csvFeatures);
        this._outputBuffer = ctxt.allocConcatBuffer();
        this._bufferRecyclable = true;
        this._outputEnd = this._outputBuffer.length;
        this._out = out;
        this._cfgColumnSeparator = schema.getColumnSeparator();
        this._cfgQuoteCharacter = schema.getQuoteChar();
        this._cfgEscapeCharacter = schema.getEscapeChar();
        this._cfgLineSeparator = schema.getLineSeparator();
        this._cfgLineSeparatorLength = this._cfgLineSeparator == null ? 0 : this._cfgLineSeparator.length;
        this._cfgNullValue = schema.getNullValueOrEmpty();
        this._cfgAllowsComments = schema.allowsComments();
        this._columnCount = schema.size();
        this._outputEscapes = esc == null ? sOutputEscapes : esc.getEscapeCodesForAscii();
        this._cfgMinSafeChar = this._calcSafeChar();
        this._cfgMaxQuoteCheckChars = 24;
        this._cfgQuoteCharEscapeChar = this._getQuoteCharEscapeChar(this._cfgEscapeQuoteCharWithEscapeChar, this._cfgQuoteCharacter, this._cfgEscapeCharacter);
        this._cfgControlCharEscapeChar = (char)(this._cfgEscapeCharacter > 0 ? (int)this._cfgEscapeCharacter : 92);
        this._verifyConfiguration(schema);
    }

    public CsvEncoder(CsvEncoder base, CsvSchema newSchema) {
        this._ioContext = base._ioContext;
        this._csvFeatures = base._csvFeatures;
        this._cfgUseFastDoubleWriter = base._cfgUseFastDoubleWriter;
        this._cfgOptimalQuoting = base._cfgOptimalQuoting;
        this._cfgIncludeMissingTail = base._cfgIncludeMissingTail;
        this._cfgAlwaysQuoteStrings = base._cfgAlwaysQuoteStrings;
        this._cfgAlwaysQuoteEmptyStrings = base._cfgAlwaysQuoteEmptyStrings;
        this._cfgAlwaysQuoteNumbers = base._cfgAlwaysQuoteNumbers;
        this._cfgEscapeQuoteCharWithEscapeChar = base._cfgEscapeQuoteCharWithEscapeChar;
        this._cfgEscapeControlCharWithEscapeChar = base._cfgEscapeControlCharWithEscapeChar;
        this._outputBuffer = base._outputBuffer;
        this._bufferRecyclable = base._bufferRecyclable;
        this._outputEnd = base._outputEnd;
        this._out = base._out;
        this._cfgMaxQuoteCheckChars = base._cfgMaxQuoteCheckChars;
        this._outputEscapes = base._outputEscapes;
        this._cfgColumnSeparator = newSchema.getColumnSeparator();
        this._cfgQuoteCharacter = newSchema.getQuoteChar();
        this._cfgEscapeCharacter = newSchema.getEscapeChar();
        this._cfgLineSeparator = newSchema.getLineSeparator();
        this._cfgLineSeparatorLength = this._cfgLineSeparator.length;
        this._cfgNullValue = newSchema.getNullValueOrEmpty();
        this._cfgAllowsComments = newSchema.allowsComments();
        this._cfgMinSafeChar = this._calcSafeChar();
        this._columnCount = newSchema.size();
        this._cfgQuoteCharEscapeChar = this._getQuoteCharEscapeChar(base._cfgEscapeQuoteCharWithEscapeChar, newSchema.getQuoteChar(), newSchema.getEscapeChar());
        this._cfgControlCharEscapeChar = (char)(this._cfgEscapeCharacter > 0 ? (int)this._cfgEscapeCharacter : 92);
        this._verifyConfiguration(newSchema);
    }

    private void _verifyConfiguration(CsvSchema schema) {
        if ((this._cfgEscapeQuoteCharWithEscapeChar || this._cfgEscapeControlCharWithEscapeChar) && !schema.usesEscapeChar()) {
            throw CsvWriteException.from(null, "Cannot use `CsvGenerator.Feature.ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR` or `CsvGenerator.Feature.ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR` if no escape character defined in `CsvSchema`", schema);
        }
    }

    private final char _getQuoteCharEscapeChar(boolean escapeQuoteCharWithEscapeChar, int quoteCharacter, int escapeCharacter) {
        char quoteEscapeChar = escapeQuoteCharWithEscapeChar && escapeCharacter > 0 ? (char)((char)escapeCharacter) : (quoteCharacter > 0 ? (char)((char)quoteCharacter) : (char)'\\');
        return quoteEscapeChar;
    }

    private final int _calcSafeChar() {
        int min = Math.max(this._cfgColumnSeparator, this._cfgQuoteCharacter);
        for (int i = 0; i < this._cfgLineSeparatorLength; ++i) {
            min = Math.max(min, this._cfgLineSeparator[i]);
        }
        return min + 1;
    }

    public CsvEncoder withSchema(CsvSchema schema) {
        return new CsvEncoder(this, schema);
    }

    public CsvEncoder setOutputEscapes(int[] esc) {
        this._outputEscapes = esc != null ? esc : sOutputEscapes;
        return this;
    }

    public Object getOutputTarget() {
        return this._out;
    }

    public int getOutputBuffered() {
        return this._outputTail;
    }

    public int nextColumnIndex() {
        return this._nextColumnToWrite;
    }

    public final void write(int columnIndex, String value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this.appendColumnSeparator();
            }
            int len = value.length();
            if (this._cfgAlwaysQuoteStrings || this._mayNeedQuotes(value, len, columnIndex)) {
                if (this._cfgEscapeCharacter > 0) {
                    this._writeQuotedAndEscaped(value, (char)this._cfgEscapeCharacter);
                } else {
                    this._writeQuoted(value);
                }
            } else {
                this.writeRaw(value);
            }
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, char[] ch, int offset, int len) throws JacksonException {
        this.write(columnIndex, new String(ch, offset, len));
    }

    public final void write(int columnIndex, int value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail + 14 > this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
            }
            if (this._cfgAlwaysQuoteNumbers) {
                this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
            }
            this._outputTail = NumberOutput.outputInt((int)value, (char[])this._outputBuffer, (int)this._outputTail);
            if (this._cfgAlwaysQuoteNumbers) {
                this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
            }
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, long value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail + 24 > this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
            }
            if (this._cfgAlwaysQuoteNumbers) {
                this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
            }
            this._outputTail = NumberOutput.outputLong((long)value, (char[])this._outputBuffer, (int)this._outputTail);
            if (this._cfgAlwaysQuoteNumbers) {
                this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
            }
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, BigInteger value) throws JacksonException {
        String numStr = value.toString();
        if (columnIndex == this._nextColumnToWrite) {
            this.appendNumberValue(numStr);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedNumber(numStr));
    }

    public final void write(int columnIndex, float value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, double value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, BigDecimal value, boolean plain) throws JacksonException {
        String numStr;
        String string = numStr = plain ? value.toPlainString() : value.toString();
        if (columnIndex == this._nextColumnToWrite) {
            this.appendNumberValue(numStr);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedNumber(numStr));
    }

    public final void write(int columnIndex, boolean value) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void writeNonEscaped(int columnIndex, String rawValue) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendRawValue(rawValue);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedRaw(rawValue));
    }

    public final void writeNull(int columnIndex) throws JacksonException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendNull();
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedNull());
    }

    public final void writeColumnName(String name) throws JacksonException {
        this.appendValue(name);
        ++this._nextColumnToWrite;
    }

    public void endRow() throws JacksonException {
        if (this._lastBuffered >= 0) {
            int last = this._lastBuffered;
            this._lastBuffered = -1;
            while (this._nextColumnToWrite <= last) {
                BufferedValue value = this._buffered[this._nextColumnToWrite];
                if (value != null) {
                    this._buffered[this._nextColumnToWrite] = null;
                    value.write(this);
                } else if (this._nextColumnToWrite > 0) {
                    this.appendColumnSeparator();
                }
                ++this._nextColumnToWrite;
            }
        } else if (this._nextColumnToWrite <= 0) {
            return;
        }
        if (this._nextColumnToWrite < this._columnCount && this._cfgIncludeMissingTail) {
            do {
                this.appendColumnSeparator();
            } while (++this._nextColumnToWrite < this._columnCount);
        }
        this._nextColumnToWrite = 0;
        if (this._outputTail + this._cfgLineSeparatorLength > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(this._cfgLineSeparator, 0, this._outputBuffer, this._outputTail, this._cfgLineSeparatorLength);
        this._outputTail += this._cfgLineSeparatorLength;
    }

    protected void appendValue(String value) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this.appendColumnSeparator();
        }
        int len = value.length();
        if (this._cfgAlwaysQuoteStrings || this._mayNeedQuotes(value, len, this._nextColumnToWrite)) {
            if (this._cfgEscapeCharacter > 0) {
                this._writeQuotedAndEscaped(value, (char)this._cfgEscapeCharacter);
            } else {
                this._writeQuoted(value);
            }
        } else {
            this.writeRaw(value);
        }
    }

    protected void appendRawValue(String value) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this.appendColumnSeparator();
        }
        this.writeRaw(value);
    }

    protected void appendValue(int value) throws JacksonException {
        if (this._outputTail + 14 > this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (this._cfgAlwaysQuoteNumbers) {
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
        }
        this._outputTail = NumberOutput.outputInt((int)value, (char[])this._outputBuffer, (int)this._outputTail);
        if (this._cfgAlwaysQuoteNumbers) {
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
        }
    }

    protected void appendValue(long value) throws JacksonException {
        if (this._outputTail + 24 > this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (this._cfgAlwaysQuoteNumbers) {
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
        }
        this._outputTail = NumberOutput.outputLong((long)value, (char[])this._outputBuffer, (int)this._outputTail);
        if (this._cfgAlwaysQuoteNumbers) {
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
        }
    }

    protected void appendValue(float value) throws JacksonException {
        String str = NumberOutput.toString((float)value, (boolean)this._cfgUseFastDoubleWriter);
        int len = str.length();
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this.writeNumber(str);
    }

    protected void appendValue(double value) throws JacksonException {
        String str = NumberOutput.toString((double)value, (boolean)this._cfgUseFastDoubleWriter);
        int len = str.length();
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this.writeNumber(str);
    }

    protected void appendNumberValue(String numStr) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this.appendColumnSeparator();
        }
        this.writeNumber(numStr);
    }

    protected void appendValue(boolean value) throws JacksonException {
        this._append(value ? TRUE_CHARS : FALSE_CHARS);
    }

    protected void appendNull() throws JacksonException {
        this._append(this._cfgNullValue);
    }

    protected void _append(char[] ch) throws JacksonException {
        int len = ch.length;
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (len > 0) {
            System.arraycopy(ch, 0, this._outputBuffer, this._outputTail, len);
        }
        this._outputTail += len;
    }

    protected void appendColumnSeparator() throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
    }

    public void writeRaw(String text) throws JacksonException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text);
        }
    }

    public void writeRaw(String text, int start, int len) throws JacksonException {
        int room = this._outputEnd - this._outputTail;
        if (room < len) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(start, start + len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text.substring(start, start + len));
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws JacksonException {
        if (len < 32) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return;
        }
        this._flushBuffer();
        try {
            this._out.write(text, offset, len);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    public void writeRaw(char c) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String text) throws JacksonException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    private void writeNumber(String text) throws JacksonException {
        int len = text.length();
        if (this._outputTail + len + 2 > this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgAlwaysQuoteNumbers) {
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
            this._outputBuffer[this._outputTail++] = (char)this._cfgQuoteCharacter;
        } else {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        }
    }

    public void _writeQuoted(String text) throws JacksonException {
        char c;
        int ptr;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char q = (char)this._cfgQuoteCharacter;
        this._outputBuffer[this._outputTail++] = q;
        int len = text.length();
        if (this._outputTail + len + len >= this._outputEnd) {
            this._writeLongQuoted(text, q);
            return;
        }
        char[] buf = this._outputBuffer;
        text.getChars(0, len, buf, ptr);
        int end = ptr + len;
        for (ptr = this._outputTail; ptr < end && (c = buf[ptr]) != q && (c >= escLen || escCodes[c] == 0); ++ptr) {
        }
        if (ptr == end) {
            this._outputBuffer[ptr] = q;
            this._outputTail = ptr + 1;
        } else {
            this._writeQuoted(text, q, ptr - this._outputTail);
        }
    }

    protected void _writeQuoted(String text, char q, int i) throws JacksonException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char[] buf = this._outputBuffer;
        this._outputTail += i;
        int len = text.length();
        while (i < len) {
            int escCode;
            char c = text.charAt(i);
            if (c < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
            } else {
                if (c == q) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    buf[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                }
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                buf[this._outputTail++] = c;
            }
            ++i;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        buf[this._outputTail++] = q;
    }

    private final void _writeLongQuoted(String text, char q) throws JacksonException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int escCode;
            char c;
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = text.charAt(i)) < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
                continue;
            }
            if (c == q) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = q;
    }

    public void _writeQuotedAndEscaped(String text, char esc) throws JacksonException {
        char c;
        int ptr;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char q = (char)this._cfgQuoteCharacter;
        this._outputBuffer[this._outputTail++] = q;
        int len = text.length();
        if (this._outputTail + len + len >= this._outputEnd) {
            this._writeLongQuotedAndEscaped(text, esc);
            return;
        }
        char[] buf = this._outputBuffer;
        text.getChars(0, len, buf, ptr);
        int end = ptr + len;
        for (ptr = this._outputTail; ptr < end && (c = buf[ptr]) != q && c != esc && (c >= escLen || escCodes[c] == 0); ++ptr) {
        }
        if (ptr == end) {
            this._outputBuffer[ptr] = q;
            this._outputTail = ptr + 1;
        } else {
            this._writeQuotedAndEscaped(text, q, esc, ptr - this._outputTail);
        }
    }

    protected void _writeQuotedAndEscaped(String text, char q, char esc, int i) throws JacksonException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char[] buf = this._outputBuffer;
        this._outputTail += i;
        int len = text.length();
        while (i < len) {
            int escCode;
            char c = text.charAt(i);
            if (c < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
            } else {
                if (c == q) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                } else if (c == esc) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
                }
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                buf[this._outputTail++] = c;
            }
            ++i;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        buf[this._outputTail++] = q;
    }

    private final void _writeLongQuotedAndEscaped(String text, char esc) throws JacksonException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        int len = text.length();
        char q = (char)this._cfgQuoteCharacter;
        for (int i = 0; i < len; ++i) {
            int escCode;
            char c;
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = text.charAt(i)) < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
                continue;
            }
            if (c == q) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            } else if (c == esc) {
                this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = q;
    }

    public void flush(boolean flushStream) throws IOException {
        this._flushBuffer();
        if (flushStream) {
            this._out.flush();
        }
    }

    public void close(boolean autoClose, boolean flushStream) throws IOException {
        if (!CsvWriteFeature.WRITE_LINEFEED_AFTER_LAST_ROW.enabledIn(this._csvFeatures)) {
            this._removeTrailingLF();
        }
        this._flushBuffer();
        if (autoClose) {
            this._out.close();
        } else if (flushStream) {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private void _removeTrailingLF() throws IOException {
        if (!this._trailingLFRemoved) {
            this._trailingLFRemoved = true;
            this._outputTail = Math.max(0, this._outputTail - this._cfgLineSeparatorLength);
        }
    }

    protected boolean _mayNeedQuotes(String value, int length, int columnIndex) {
        if (this._cfgQuoteCharacter < 0) {
            return false;
        }
        if (this._cfgOptimalQuoting) {
            if (this._cfgAllowsComments && columnIndex == 0 && length > 0 && value.charAt(0) == '#') {
                return true;
            }
            if (this._cfgEscapeCharacter > 0) {
                return this._needsQuotingStrict(value, this._cfgEscapeCharacter);
            }
            return this._needsQuotingStrict(value);
        }
        if (length > this._cfgMaxQuoteCheckChars) {
            return true;
        }
        if (this._cfgEscapeCharacter > 0) {
            return this._needsQuotingLoose(value, this._cfgEscapeCharacter);
        }
        if (this._cfgAlwaysQuoteEmptyStrings && length == 0) {
            return true;
        }
        return this._needsQuotingLoose(value);
    }

    protected final boolean _needsQuotingLoose(String value) {
        char esc1 = this._cfgQuoteCharEscapeChar;
        char esc2 = this._cfgControlCharEscapeChar;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= this._cfgMinSafeChar && c != esc1 && c != esc2) continue;
            return true;
        }
        return false;
    }

    protected final boolean _needsQuotingLoose(String value, int esc) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= this._cfgMinSafeChar && ch != esc) continue;
            return true;
        }
        return false;
    }

    protected boolean _needsQuotingStrict(String value) {
        int minSafe = this._cfgMinSafeChar;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char lfFirst = this._cfgLineSeparatorLength == 0 ? (char)'\u0000' : this._cfgLineSeparator[0];
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= minSafe || c != this._cfgColumnSeparator && c != this._cfgQuoteCharacter && (c >= escLen || escCodes[c] == 0) && c != lfFirst) continue;
            return true;
        }
        return false;
    }

    protected boolean _needsQuotingStrict(String value, int esc) {
        int minSafe = this._cfgMinSafeChar;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char lfFirst = this._cfgLineSeparatorLength == 0 ? (char)'\u0000' : this._cfgLineSeparator[0];
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (!(c < minSafe ? c == this._cfgColumnSeparator || c == this._cfgQuoteCharacter || c < escLen && escCodes[c] != 0 || c == lfFirst : c == esc)) continue;
            return true;
        }
        return false;
    }

    protected void _buffer(int index, BufferedValue v) {
        this._lastBuffered = Math.max(this._lastBuffered, index);
        if (index >= this._buffered.length) {
            this._buffered = Arrays.copyOf(this._buffered, Math.max(index + 1, this._columnCount));
        }
        this._buffered[index] = v;
    }

    protected void _flushBuffer() throws JacksonException {
        if (this._outputTail > 0) {
            this._charsWritten += this._outputTail;
            try {
                this._out.write(this._outputBuffer, 0, this._outputTail);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            this._outputTail = 0;
        }
    }

    public void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    private void _appendCharacterEscape(char ch, int escCode) throws JacksonException {
        if (escCode >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
            this._outputBuffer[this._outputTail++] = (char)escCode;
            return;
        }
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int ptr = this._outputTail;
        char[] buf = this._outputBuffer;
        buf[ptr++] = 92;
        buf[ptr++] = 117;
        if (ch > '\u00ff') {
            int hi = ch >> 8 & 0xFF;
            buf[ptr++] = HEX_CHARS[hi >> 4];
            buf[ptr++] = HEX_CHARS[hi & 0xF];
            ch = (char)(ch & 0xFF);
        } else {
            buf[ptr++] = 48;
            buf[ptr++] = 48;
        }
        buf[ptr++] = HEX_CHARS[ch >> 4];
        buf[ptr++] = HEX_CHARS[ch & 0xF];
        this._outputTail = ptr;
    }

    protected JacksonException _wrapIOFailure(IOException e) {
        return JacksonIOException.construct((IOException)e);
    }
}

