/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.ser;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.reflect.ReflectData;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.databind.DatabindException;
import tools.jackson.dataformat.avro.AvroGenerator;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.ser.MapWriteContext;
import tools.jackson.dataformat.avro.ser.ObjectWriteContext;
import tools.jackson.dataformat.avro.ser.RootContext;

public abstract class AvroWriteContext
extends TokenStreamContext {
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_BIG_DECIMAL = BigDecimal.class;
    private static final Class<?> CLS_GENERIC_RECORD = GenericData.Record.class;
    private static final Class<?> CLS_GENERIC_ARRAY = GenericData.Array.class;
    protected final AvroWriteContext _parent;
    protected final AvroGenerator _generator;
    protected final Schema _schema;
    protected Object _currentValue;

    protected AvroWriteContext(int type, AvroWriteContext parent, AvroGenerator generator, Schema schema, Object currValue) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
        this._generator = generator;
        this._schema = schema;
        this._currentValue = currValue;
    }

    public static AvroWriteContext createRootContext(AvroGenerator generator, Schema schema, BinaryEncoder encoder) {
        return new RootContext(generator, schema, encoder);
    }

    public static AvroWriteContext nullContext() {
        return NullContext.instance;
    }

    public abstract AvroWriteContext createChildArrayContext(Object var1);

    public abstract AvroWriteContext createChildObjectContext(Object var1);

    public void complete() throws IOException {
        throw new IllegalStateException("Can not be called on " + ((Object)((Object)this)).getClass().getName());
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public final AvroWriteContext getParent() {
        return this._parent;
    }

    public String currentName() {
        return null;
    }

    public boolean writeName(String name) throws IOException {
        return false;
    }

    public abstract void writeValue(Object var1) throws IOException;

    public void writeBinary(byte[] data, int offset, int len) throws IOException {
        if (offset != 0 || len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        this.writeValue(data);
    }

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeNull() throws IOException;

    public abstract Object rawValue();

    public boolean canClose() {
        return true;
    }

    protected abstract void appendDesc(StringBuilder var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.appendDesc(sb);
        return sb.toString();
    }

    protected GenericRecord _createRecord(Schema schema, Object currValue) {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.UNION) {
            try {
                schema = AvroWriteContext.resolveUnionSchema(schema, currValue);
            }
            catch (UnresolvedUnionException e) {
                schema = this._recordOrMapFromUnion(schema);
            }
        }
        if (type == Schema.Type.MAP) {
            throw new IllegalStateException("_createRecord should never be called for elements of type MAP");
        }
        try {
            return new GenericData.Record(schema);
        }
        catch (RuntimeException e) {
            throw DatabindException.from((JsonGenerator)null, (String)("Failed to create Record type from " + String.valueOf(type)), (Throwable)e);
        }
    }

    protected GenericRecord _createRecord(Schema schema) {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.UNION) {
            schema = this._recordOrMapFromUnion(schema);
        }
        if (type == Schema.Type.MAP) {
            throw new IllegalStateException("_createRecord should never be called for elements of type MAP");
        }
        try {
            return new GenericData.Record(schema);
        }
        catch (RuntimeException e) {
            throw DatabindException.from((JsonGenerator)null, (String)("Failed to create Record type from " + String.valueOf(type)), (Throwable)e);
        }
    }

    protected GenericArray<Object> _createArray(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            int arraySchemaIndex = schema.getIndexNamed(Schema.Type.ARRAY.getName());
            if (arraySchemaIndex < 0) {
                throw new IllegalStateException("No Array type found in union type: " + String.valueOf(schema));
            }
            schema = (Schema)schema.getTypes().get(arraySchemaIndex);
        }
        return new GenericData.Array(8, schema);
    }

    protected AvroWriteContext _createObjectContext(Schema schema, Object currValue) {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.UNION) {
            if (currValue == null) {
                schema = this._recordOrMapFromUnion(schema);
            } else {
                try {
                    schema = AvroWriteContext.resolveUnionSchema(schema, currValue);
                }
                catch (UnresolvedUnionException e) {
                    schema = this._recordOrMapFromUnion(schema);
                }
            }
            type = schema.getType();
        }
        if (type == Schema.Type.MAP) {
            return new MapWriteContext(this, this._generator, schema, currValue);
        }
        return new ObjectWriteContext(this, this._generator, this._createRecord(schema), currValue);
    }

    protected Schema _recordOrMapFromUnion(Schema unionSchema) {
        Schema match = null;
        for (Schema s : unionSchema.getTypes()) {
            Schema.Type type = s.getType();
            if (type != Schema.Type.RECORD && type != Schema.Type.MAP) continue;
            if (match != null) {
                throw new IllegalStateException("Multiple Record and/or Map types, can not figure out which to use for: " + String.valueOf(unionSchema));
            }
            match = s;
        }
        if (match == null) {
            throw new IllegalStateException("No Record or Map type found in union type: " + String.valueOf(unionSchema));
        }
        return match;
    }

    public static int resolveUnionIndex(Schema unionSchema, Object datum) {
        List types = unionSchema.getTypes();
        if (datum == null) {
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                Schema type = (Schema)types.get(i);
                if (type.getType() != Schema.Type.NULL) continue;
                return i;
            }
        } else {
            Class<?> raw = datum.getClass();
            if (raw == CLS_STRING) {
                return AvroWriteContext._resolveStringIndex(unionSchema, types, (String)datum);
            }
            int ix = AvroWriteContext._findNotNullIndex(types);
            if (ix >= 0) {
                return ix;
            }
            if (raw == CLS_BIG_DECIMAL) {
                return AvroWriteContext._resolveBigDecimalIndex(unionSchema, types, (BigDecimal)datum);
            }
            if (raw == CLS_GENERIC_RECORD) {
                return AvroWriteContext._resolveRecordIndex(unionSchema, types, (GenericData.Record)datum);
            }
            if (raw == CLS_GENERIC_ARRAY) {
                return AvroWriteContext._resolveArrayIndex(unionSchema, types, (GenericData.Array)datum);
            }
            if (datum instanceof Map) {
                return AvroWriteContext._resolveMapIndex(unionSchema, types, datum);
            }
            String typeId = AvroSchemaHelper.getTypeId(datum.getClass());
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                Schema schema = (Schema)types.get(i);
                if (!typeId.equals(AvroSchemaHelper.getTypeId(schema))) continue;
                return i;
            }
        }
        return ReflectData.get().resolveUnion(unionSchema, datum);
    }

    public static Schema resolveUnionType(Schema unionSchema, Object datum) {
        List types = unionSchema.getTypes();
        if (datum == null) {
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                Schema type = (Schema)types.get(i);
                if (type.getType() != Schema.Type.NULL) continue;
                return type;
            }
        } else {
            Class<?> raw = datum.getClass();
            if (raw == CLS_STRING) {
                return (Schema)types.get(AvroWriteContext._resolveStringIndex(unionSchema, types, (String)datum));
            }
            Schema sch = AvroWriteContext._findNotNull(types);
            if (sch != null) {
                return sch;
            }
            if (raw == CLS_BIG_DECIMAL) {
                return (Schema)types.get(AvroWriteContext._resolveBigDecimalIndex(unionSchema, types, (BigDecimal)datum));
            }
            if (raw == CLS_GENERIC_RECORD) {
                return (Schema)types.get(AvroWriteContext._resolveRecordIndex(unionSchema, types, (GenericData.Record)datum));
            }
            if (raw == CLS_GENERIC_ARRAY) {
                return (Schema)types.get(AvroWriteContext._resolveArrayIndex(unionSchema, types, (GenericData.Array)datum));
            }
            if (datum instanceof Map) {
                return (Schema)types.get(AvroWriteContext._resolveMapIndex(unionSchema, types, datum));
            }
            String typeId = AvroSchemaHelper.getTypeId(datum.getClass());
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                Schema schema = (Schema)types.get(i);
                if (!typeId.equals(AvroSchemaHelper.getTypeId(schema))) continue;
                return schema;
            }
        }
        int ix = ReflectData.get().resolveUnion(unionSchema, datum);
        return (Schema)types.get(ix);
    }

    private static int _resolveStringIndex(Schema unionSchema, List<Schema> types, String value) {
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            Schema schema = types.get(i);
            Schema.Type t = schema.getType();
            if (t == Schema.Type.STRING) {
                return i;
            }
            if (t == Schema.Type.ENUM) {
                return i;
            }
            if (t == Schema.Type.INT && value.length() == 1 && AvroSchemaHelper.getTypeId(Character.class).equals(schema.getProp("java-class"))) {
                return i;
            }
            if (t != Schema.Type.ARRAY || schema.getElementType().getType() != Schema.Type.INT || !AvroSchemaHelper.getTypeId(Character.class).equals(schema.getElementType().getProp("java-class"))) continue;
            return i;
        }
        return ReflectData.get().resolveUnion(unionSchema, (Object)value);
    }

    private static Schema _findNotNull(List<Schema> types) {
        if (types.size() == 2) {
            if (types.get(0).getType() == Schema.Type.NULL) {
                return types.get(1);
            }
            if (types.get(1).getType() == Schema.Type.NULL) {
                return types.get(0);
            }
        }
        return null;
    }

    private static int _findNotNullIndex(List<Schema> types) {
        if (types.size() == 2) {
            if (types.get(0).getType() == Schema.Type.NULL) {
                return 1;
            }
            if (types.get(1).getType() == Schema.Type.NULL) {
                return 0;
            }
        }
        return -1;
    }

    private static int _resolveBigDecimalIndex(Schema unionSchema, List<Schema> types, BigDecimal value) {
        int match = -1;
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            Schema schema = types.get(i);
            Schema.Type t = schema.getType();
            if (t == Schema.Type.DOUBLE) {
                return i;
            }
            if (t != Schema.Type.DOUBLE) continue;
            match = i;
        }
        if (match < 0) {
            match = ReflectData.get().resolveUnion(unionSchema, (Object)value);
        }
        return match;
    }

    private static int _resolveMapIndex(Schema unionSchema, List<Schema> types, Object value) {
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            if (types.get(i).getType() != Schema.Type.MAP) continue;
            return i;
        }
        return ReflectData.get().resolveUnion(unionSchema, value);
    }

    private static int _resolveRecordIndex(Schema unionSchema, List<Schema> types, GenericData.Record value) {
        String name = value.getSchema().getFullName();
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            Schema sch = types.get(i);
            if (sch.getType() != Schema.Type.RECORD || !name.equals(sch.getFullName())) continue;
            return i;
        }
        return ReflectData.get().resolveUnion(unionSchema, (Object)value);
    }

    private static int _resolveArrayIndex(Schema unionSchema, List<Schema> types, GenericData.Array<?> value) {
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            Schema sch = types.get(i);
            if (sch.getType() != Schema.Type.ARRAY) continue;
            return i;
        }
        return ReflectData.get().resolveUnion(unionSchema, value);
    }

    public static Schema resolveUnionSchema(Schema unionSchema, Object datum) {
        return AvroWriteContext.resolveUnionType(unionSchema, datum);
    }

    private static final class NullContext
    extends AvroWriteContext {
        public static final NullContext instance = new NullContext();

        private NullContext() {
            super(0, null, null, null, null);
        }

        @Override
        public Object rawValue() {
            return null;
        }

        @Override
        public final AvroWriteContext createChildArrayContext(Object currValue) {
            this._reportError();
            return null;
        }

        @Override
        public final AvroWriteContext createChildObjectContext(Object currValue) {
            this._reportError();
            return null;
        }

        @Override
        public void writeValue(Object value) {
            this._reportError();
        }

        @Override
        public void writeString(String value) {
            this._reportError();
        }

        @Override
        public void writeNull() {
            this._reportError();
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("?");
        }

        protected void _reportError() {
            throw new IllegalStateException("Can not write Avro output without specifying Schema");
        }
    }
}

