/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.ser;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.dataformat.avro.AvroGenerator;
import tools.jackson.dataformat.avro.ser.ArrayWriteContext;
import tools.jackson.dataformat.avro.ser.AvroWriteContext;
import tools.jackson.dataformat.avro.ser.KeyValueContext;
import tools.jackson.dataformat.avro.ser.NopWriteContext;

public final class ObjectWriteContext
extends KeyValueContext {
    protected final GenericRecord _record;
    protected Schema.Field _nextField;

    public ObjectWriteContext(AvroWriteContext parent, AvroGenerator generator, GenericRecord record, Object currValue) {
        super(parent, generator, record.getSchema(), currValue);
        this._record = record;
    }

    @Override
    public Object rawValue() {
        return this._record;
    }

    @Override
    public final AvroWriteContext createChildArrayContext(Object currValue) {
        this._verifyValueWrite();
        Schema.Field field = this._findField();
        if (field == null) {
            return new NopWriteContext(1, this, this._generator, currValue);
        }
        ArrayWriteContext child = new ArrayWriteContext(this, this._generator, this._createArray(field.schema()), currValue);
        this._record.put(this._currentName, ((AvroWriteContext)child).rawValue());
        return child;
    }

    @Override
    public AvroWriteContext createChildObjectContext(Object currValue) {
        this._verifyValueWrite();
        Schema.Field field = this._findField();
        if (field == null) {
            return new NopWriteContext(2, this, this._generator, currValue);
        }
        AvroWriteContext child = this._createObjectContext(field.schema(), currValue);
        this._record.put(this._currentName, child.rawValue());
        return child;
    }

    @Override
    public final boolean writeName(String name) {
        this._currentName = name;
        this._expectValue = true;
        Schema.Field field = this._schema.getField(name);
        if (field == null) {
            this._reportUnknownField(name);
            this._nextField = null;
            return false;
        }
        this._nextField = field;
        return true;
    }

    @Override
    public void writeValue(Object value) {
        this._verifyValueWrite();
        if (this._nextField != null) {
            this._record.put(this._nextField.pos(), value);
        }
    }

    @Override
    public void writeString(String value) {
        this._verifyValueWrite();
        if (this._nextField != null) {
            this._record.put(this._nextField.pos(), (Object)value);
        }
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite();
        if (this._nextField != null) {
            this._record.put(this._nextField.pos(), null);
        }
    }

    protected final void _verifyValueWrite() {
        if (!this._expectValue) {
            throw new IllegalStateException("Expecting FIELD_NAME, not value");
        }
        this._expectValue = false;
    }

    protected Schema.Field _findField() {
        if (this._currentName == null) {
            throw new IllegalStateException("No current field name");
        }
        Schema.Field f = this._schema.getField(this._currentName);
        if (f == null) {
            this._reportUnknownField(this._currentName);
        }
        return f;
    }

    protected void _reportUnknownField(String name) {
        if (!this._generator.isEnabled(StreamWriteFeature.IGNORE_UNKNOWN)) {
            throw new IllegalStateException("No field named '" + this._currentName + "'");
        }
    }
}

