/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.dataformat.avro.AvroFactory;
import tools.jackson.dataformat.avro.AvroModule;
import tools.jackson.dataformat.avro.AvroReadFeature;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.AvroSubTypeValidator;
import tools.jackson.dataformat.avro.AvroWriteFeature;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.schema.AvroSchemaGenerator;

public class AvroMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public AvroMapper() {
        this(new AvroFactory());
    }

    public AvroMapper(AvroFactory f) {
        this(new Builder(f));
    }

    public AvroMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new AvroFactory());
    }

    public static Builder builder(AvroFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static AvroMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroFactory tokenStreamFactory() {
        return (AvroFactory)this._streamFactory;
    }

    public AvroSchema schemaFor(Class<?> type) {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        try {
            this.acceptJsonFormatVisitor(type, gen);
            return gen.getGeneratedSchema();
        }
        catch (RuntimeException e0) {
            throw this._invalidSchemaDefinition(this.constructType(type), e0);
        }
    }

    public AvroSchema schemaFor(JavaType type) {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        try {
            this.acceptJsonFormatVisitor(type, gen);
            return gen.getGeneratedSchema();
        }
        catch (RuntimeException e0) {
            throw this._invalidSchemaDefinition(type, e0);
        }
    }

    protected JacksonException _invalidSchemaDefinition(JavaType type, Exception e0) {
        String msg = String.format("Failed to generate `AvroSchema` for %s, problem: (%s) %s", ClassUtil.getTypeDescription((JavaType)type), e0.getClass().getName(), e0.getMessage());
        return InvalidDefinitionException.from((JsonGenerator)null, (String)msg, (JavaType)type).withCause((Throwable)e0);
    }

    public AvroSchema schemaFrom(InputStream in) throws IOException {
        try {
            AvroSchema avroSchema = new AvroSchema(new Schema.Parser().setValidate(true).parse(in));
            return avroSchema;
        }
        finally {
            in.close();
        }
    }

    public AvroSchema schemaFrom(String schemaAsString) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaAsString));
    }

    public AvroSchema schemaFrom(File schemaFile) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaFile));
    }

    public static class Builder
    extends MapperBuilder<AvroMapper, Builder> {
        public Builder(AvroFactory f) {
            super((TokenStreamFactory)f);
            this.addModule(new AvroModule());
            this._baseSettings = this._baseSettings.with((PolymorphicTypeValidator)AvroSubTypeValidator.instance);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public AvroMapper build() {
            return new AvroMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(AvroReadFeature ... features) {
            for (AvroReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(AvroReadFeature ... features) {
            for (AvroReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(AvroReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(AvroWriteFeature ... features) {
            for (AvroWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(AvroWriteFeature ... features) {
            for (AvroWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(AvroWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final AvroMapper MAPPER = AvroMapper.builder().build();

        private SharedWrapper() {
        }

        public static AvroMapper wrapped() {
            return MAPPER;
        }
    }
}

