/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DatabindException;
import tools.jackson.dataformat.avro.deser.AvroReaderFactory;
import tools.jackson.dataformat.avro.deser.AvroStructureReader;

public class AvroSchema
implements FormatSchema {
    public static final String TYPE_ID = "avro";
    protected final Schema _writerSchema;
    protected final AtomicReference<AvroStructureReader> _reader = new AtomicReference();

    public AvroSchema(Schema asch) {
        this._writerSchema = asch;
    }

    public AvroSchema withReaderSchema(AvroSchema readerSchema) throws DatabindException {
        SchemaCompatibility.SchemaPairCompatibility comp;
        Schema w = this._writerSchema;
        Schema r = readerSchema.getAvroSchema();
        if (r.equals((Object)w)) {
            return this;
        }
        w = Schema.applyAliases((Schema)w, (Schema)r);
        if (r.getType() == w.getType() && !this._schemaNamesEqual(w, r)) {
            throw DatabindException.from((JsonParser)null, (String)String.format("Incompatible writer/reader schemas: root %ss have different names (\"%s\" vs \"%s\"), no match via aliases", r.getType().getName(), w.getFullName(), r.getFullName()));
        }
        try {
            comp = SchemaCompatibility.checkReaderWriterCompatibility((Schema)r, (Schema)w);
        }
        catch (Exception e) {
            throw DatabindException.from((JsonParser)null, (String)String.format("Failed to resolve given writer/reader schemas, problem: (%s) %s", e.getClass().getName(), e.getMessage()));
        }
        if (comp.getType() != SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE) {
            throw DatabindException.from((JsonParser)null, (String)String.format("Incompatible writer/reader schemas: %s", comp.getDescription()));
        }
        return Resolving.create(w, r);
    }

    private boolean _schemaNamesEqual(Schema w, Schema r) {
        String rname;
        String wname = w.getFullName();
        if (wname == (rname = r.getFullName()) || wname != null && wname.equals(rname)) {
            return true;
        }
        Set aliases = r.getAliases();
        return aliases.contains(wname);
    }

    public AvroSchema withUnsafeReaderSchema(AvroSchema readerSchema) throws DatabindException {
        Schema w = this._writerSchema;
        Schema r = readerSchema.getAvroSchema();
        if (r.equals((Object)w)) {
            return this;
        }
        w = Schema.applyAliases((Schema)w, (Schema)r);
        return Resolving.create(w, r);
    }

    public String getSchemaType() {
        return TYPE_ID;
    }

    public Schema getAvroSchema() {
        return this._writerSchema;
    }

    public AvroStructureReader getReader() {
        AvroStructureReader r = this._reader.get();
        if (r == null) {
            r = this._constructReader();
            this._reader.set(r);
        }
        return r;
    }

    protected AvroStructureReader _constructReader() {
        return AvroReaderFactory.createFor(this._writerSchema);
    }

    public String toString() {
        return String.format("{AvroSchema: name=%s}", this._writerSchema.getFullName());
    }

    public int hashCode() {
        return this._writerSchema.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AvroSchema other = (AvroSchema)o;
        return this._writerSchema.equals((Object)other._writerSchema);
    }

    private static final class Resolving
    extends AvroSchema {
        private final Schema _readerSchema;

        public Resolving(Schema writer, Schema reader) {
            super(writer);
            this._readerSchema = reader;
        }

        public static Resolving create(Schema writer, Schema reader) {
            return new Resolving(writer, reader);
        }

        @Override
        protected AvroStructureReader _constructReader() {
            return AvroReaderFactory.createFor(this._writerSchema, this._readerSchema);
        }

        @Override
        public String toString() {
            return String.format("{AvroSchema.Resolving: name=%s}", this._writerSchema.getFullName());
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this._readerSchema.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Resolving other = (Resolving)o;
            return this._writerSchema.equals((Object)other._writerSchema) && this._readerSchema.equals((Object)other._readerSchema);
        }
    }
}

