/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject;
import java.lang.annotation.Annotation;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.NullValueProvider;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.ClassUtil;

public class CreatorProperty
extends SettableBeanProperty {
    protected final AnnotatedParameter _annotated;
    protected final JacksonInject.Value _injectableValue;
    protected SettableBeanProperty _fallbackSetter;
    protected final int _creatorIndex;
    protected boolean _ignorable;

    protected CreatorProperty(PropertyName name, JavaType type, PropertyName wrapperName, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedParameter param, int index, JacksonInject.Value injectable, PropertyMetadata metadata) {
        super(name, type, wrapperName, typeDeser, contextAnnotations, metadata);
        this._annotated = param;
        this._creatorIndex = index;
        this._injectableValue = injectable;
        this._fallbackSetter = null;
    }

    public static CreatorProperty construct(PropertyName name, JavaType type, PropertyName wrapperName, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedParameter param, int index, JacksonInject.Value injectable, PropertyMetadata metadata) {
        return new CreatorProperty(name, type, wrapperName, typeDeser, contextAnnotations, param, index, injectable, metadata);
    }

    protected CreatorProperty(CreatorProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._injectableValue = src._injectableValue;
        this._fallbackSetter = src._fallbackSetter;
        this._creatorIndex = src._creatorIndex;
        this._ignorable = src._ignorable;
    }

    protected CreatorProperty(CreatorProperty src, ValueDeserializer<?> deser, NullValueProvider nva) {
        super(src, deser, nva);
        this._annotated = src._annotated;
        this._injectableValue = src._injectableValue;
        this._fallbackSetter = src._fallbackSetter;
        this._creatorIndex = src._creatorIndex;
        this._ignorable = src._ignorable;
    }

    protected CreatorProperty(CreatorProperty src, TypeDeserializer typeDeser) {
        super((SettableBeanProperty)src, typeDeser);
        this._annotated = src._annotated;
        this._injectableValue = src._injectableValue;
        this._fallbackSetter = src._fallbackSetter;
        this._creatorIndex = src._creatorIndex;
        this._ignorable = src._ignorable;
    }

    @Override
    public SettableBeanProperty withName(PropertyName newName) {
        return new CreatorProperty(this, newName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(ValueDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        NullValueProvider nvp = this._valueDeserializer == this._nullProvider ? deser : this._nullProvider;
        return new CreatorProperty(this, deser, nvp);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new CreatorProperty(this, this._valueDeserializer, nva);
    }

    public SettableBeanProperty withValueTypeDeserializer(TypeDeserializer typeDeser) {
        if (this._valueTypeDeserializer == typeDeser) {
            return this;
        }
        return new CreatorProperty(this, typeDeser);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        if (this._fallbackSetter != null) {
            this._fallbackSetter.fixAccess(config);
        }
    }

    public void setFallbackSetter(SettableBeanProperty fallbackSetter) {
        this._fallbackSetter = fallbackSetter;
    }

    @Override
    public void markAsIgnorable() {
        this._ignorable = true;
    }

    @Override
    public boolean isIgnorable() {
        return this._ignorable;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._annotated == null) {
            return null;
        }
        return this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public int getCreatorIndex() {
        return this._creatorIndex;
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        this._verifySetter();
        this._fallbackSetter.set(ctxt, instance, this.deserialize(p, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        this._verifySetter();
        return this._fallbackSetter.setAndReturn(ctxt, instance, this.deserialize(p, ctxt));
    }

    @Override
    public void set(DeserializationContext ctxt, Object instance, Object value) {
        this._verifySetter();
        this._fallbackSetter.set(ctxt, instance, value);
    }

    @Override
    public Object setAndReturn(DeserializationContext ctxt, Object instance, Object value) {
        this._verifySetter();
        return this._fallbackSetter.setAndReturn(ctxt, instance, value);
    }

    @Override
    public PropertyMetadata getMetadata() {
        PropertyMetadata md = super.getMetadata();
        if (this._fallbackSetter != null) {
            return md.withMergeInfo(this._fallbackSetter.getMetadata().getMergeInfo());
        }
        return md;
    }

    @Override
    public Object getInjectableValueId() {
        return this._injectableValue == null ? null : this._injectableValue.getId();
    }

    @Override
    public JacksonInject.Value getInjectionDefinition() {
        return this._injectableValue;
    }

    @Override
    public boolean isInjectionOnly() {
        return this._injectableValue != null && !this._injectableValue.willUseInput(true);
    }

    @Override
    public String toString() {
        return "[creator property, name " + ClassUtil.name(this.getName()) + "; inject id '" + String.valueOf(this.getInjectableValueId()) + "']";
    }

    private final void _verifySetter() throws JacksonException {
        if (this._fallbackSetter == null) {
            this._reportMissingSetter(null, null);
        }
    }

    private void _reportMissingSetter(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String clsDesc = this._annotated == null ? "UNKNOWN TYPE" : ClassUtil.getClassDescription(this._annotated.getOwner().getDeclaringClass());
        String msg = String.format("No fallback setter/field defined for creator property %s (of %s)", ClassUtil.name(this.getName()), clsDesc);
        if (ctxt == null) {
            throw InvalidDefinitionException.from(p, msg, this.getType());
        }
        ctxt.reportBadDefinition(this.getType(), msg);
    }
}

