/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import tools.dynamia.modules.importer.ImportOperationException;
import tools.dynamia.modules.importer.ImportUtils;

public class ImportExcelTemplate {
    private InputStream excelTemplate;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public ImportExcelTemplate(InputStream excelTemplate) {
        this.excelTemplate = excelTemplate;
    }

    public ImportExcelTemplate(File excelTemplate) {
        try {
            this.excelTemplate = new FileInputStream(excelTemplate);
        }
        catch (FileNotFoundException e) {
            throw new ImportOperationException("Invalid file", e);
        }
    }

    public ImportExcelTemplate(URL url) {
        try {
            this.excelTemplate = url.openStream();
        }
        catch (IOException e) {
            throw new ImportOperationException("Error opening stream from URL", e);
        }
    }

    public void addVar(String cellName, Object value) {
        this.variables.put(cellName, value);
    }

    public void addVars(Map<String, Object> vars) {
        this.variables.putAll(vars);
    }

    public File parse(String outputname) throws IOException {
        Workbook workbook = WorkbookFactory.create((InputStream)this.excelTemplate);
        Sheet sheet = workbook.getSheetAt(0);
        this.variables.forEach((k, v) -> {
            Cell cell = ImportUtils.findCellByCoordinate(sheet, k);
            ImportUtils.setCellValue(cell, v);
        });
        File outfile = File.createTempFile(outputname, ".xlsx");
        workbook.write((OutputStream)new FileOutputStream(outfile));
        workbook.close();
        return outfile;
    }
}

