/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class PushoverMessage
implements Message {
    private static final Logger LOGGER = Logger.getLogger(PushoverMessage.class.getName());
    private final String userToken;
    private final String appToken;
    private String extraMessage;
    private String content;
    private String title;
    private Integer priority = 0;
    private String url;
    private String urlTitle;

    public PushoverMessage(String userToken, String appToken, String extraMessage) {
        this.userToken = userToken;
        this.appToken = appToken;
        this.extraMessage = extraMessage;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrl(String url, String title) {
        this.url = url;
        this.urlTitle = title;
    }

    @Override
    public void highPriority() {
        this.priority = 1;
    }

    @Override
    public void normalPriority() {
        this.priority = 0;
    }

    @Override
    public void lowPriority() {
        this.priority = -1;
    }

    @Override
    public void send() {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod("https://api.pushover.net/1/messages.json");
        post.setRequestBody(new NameValuePair[]{new NameValuePair("token", this.appToken), new NameValuePair("user", this.userToken), new NameValuePair("message", this.content + "\n\n" + this.extraMessage), new NameValuePair("title", this.title), new NameValuePair("priority", this.priority.toString()), new NameValuePair("url", this.url), new NameValuePair("url_title", this.urlTitle)});
        try {
            client.executeMethod((HttpMethod)post);
        }
        catch (IOException e) {
            LOGGER.severe("Error while sending notification: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

