/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.scm.ChangeLogSet;
import java.util.logging.Logger;
import tools.devnull.jenkins.plugins.buildnotifications.BuildStatus;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class BuildNotifier {
    private static final Logger LOGGER = Logger.getLogger(BuildNotifier.class.getName());
    private final Message message;
    private final AbstractBuild build;
    private final BuildStatus status;
    private final Result result;
    private final String baseUrl;

    public BuildNotifier(Message message, AbstractBuild build, String baseUrl) {
        this.message = message;
        this.build = build;
        this.status = BuildStatus.of(build);
        this.result = build.getResult();
        this.baseUrl = baseUrl;
    }

    public void sendNotification() {
        LOGGER.info("Sending notification...");
        this.setPriority();
        this.setContent();
        this.setTitle();
        this.setUrl();
        this.message.send();
    }

    private void setUrl() {
        this.message.setUrl(String.format("%s%s", this.baseUrl, this.build.getUrl()), "Go to build");
    }

    private void setContent() {
        if (this.build.getChangeSet().getItems().length == 0) {
            this.message.setContent(this.result.toString());
        } else {
            StringBuilder changes = new StringBuilder();
            for (ChangeLogSet.Entry change : this.build.getChangeSet()) {
                changes.append("\n");
                changes.append(change.getMsg());
                changes.append(" - ");
                changes.append(change.getAuthor());
            }
            this.message.setContent(String.format("%s%n%s", this.result.toString(), changes.toString()));
        }
    }

    private void setTitle() {
        this.message.setTitle(String.format("%s - Build #%d of %s", this.status.tag(), this.build.getNumber(), this.build.getProject().getName()));
    }

    private void setPriority() {
        switch (this.status) {
            case FIXED: {
                this.message.normalPriority();
                break;
            }
            case BROKEN: 
            case STILL_BROKEN: {
                this.message.highPriority();
                break;
            }
            case SUCCESSFUL: {
                this.message.lowPriority();
            }
        }
    }
}

