/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class BotecoMessage
implements Message {
    private static final Logger LOGGER = Logger.getLogger(BotecoMessage.class.getName());
    private final String endpoint;
    private String extraMessage;
    private String content;
    private String title;
    private String url;
    private String priority = "normal";

    public BotecoMessage(String eventId, String endpoint, String extraMessage) {
        this.endpoint = endpoint.endsWith("/") ? endpoint + eventId : endpoint + "/" + eventId;
        this.extraMessage = extraMessage;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrl(String url, String title) {
        this.url = url;
    }

    @Override
    public void highPriority() {
        this.priority = "high";
    }

    @Override
    public void normalPriority() {
        this.priority = "normal";
    }

    @Override
    public void lowPriority() {
        this.priority = "low";
    }

    @Override
    public void send() {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(this.endpoint);
        post.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("title", this.title);
        values.put("text", this.content + "\n\n" + this.extraMessage);
        values.put("url", this.url);
        values.put("priority", this.priority);
        try {
            post.setRequestEntity((RequestEntity)new StringRequestEntity(JSONObject.fromObject(values).toString(), "application/json", "UTF-8"));
            client.executeMethod((HttpMethod)post);
        }
        catch (IOException e) {
            LOGGER.severe("Error while sending notification: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

