/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import tools.devnull.jenkins.plugins.buildnotifications.BaseNotifier;
import tools.devnull.jenkins.plugins.buildnotifications.Message;
import tools.devnull.jenkins.plugins.buildnotifications.TelegramMessage;

public class TelegramNotifier
extends BaseNotifier {
    @DataBoundConstructor
    public TelegramNotifier(String globalTarget, String successfulTarget, String brokenTarget, String stillBrokenTarget, String fixedTarget, boolean sendIfSuccess) {
        super(globalTarget, successfulTarget, brokenTarget, stillBrokenTarget, fixedTarget, sendIfSuccess);
    }

    @Override
    protected Message createMessage(String target, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        TelegramDescriptor descriptor = (TelegramDescriptor)this.getDescriptor();
        return new TelegramMessage(descriptor.getBotToken(), target);
    }

    @Extension
    public static class TelegramDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String botToken;

        public TelegramDescriptor() {
            this.load();
        }

        public String getBotToken() {
            return this.botToken;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            JSONObject config = json.getJSONObject("telegram");
            this.botToken = config.getString("botToken");
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Telegram Notification";
        }
    }
}

