/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.model.AbstractBuild;
import hudson.model.Result;

public enum BuildStatus {
    BROKEN("Broken"),
    STILL_BROKEN("Still Broken"),
    FIXED("Fixed"),
    SUCCESSFUL("Successful");

    private final String tag;

    private BuildStatus(String tag) {
        this.tag = tag;
    }

    public String tag() {
        return this.tag;
    }

    public static BuildStatus of(AbstractBuild build) {
        AbstractBuild previousBuild = build.getPreviousBuild();
        if (build.getResult() == Result.SUCCESS) {
            if (previousBuild != null) {
                return previousBuild.getResult() == Result.SUCCESS ? SUCCESSFUL : FIXED;
            }
            return SUCCESSFUL;
        }
        if (previousBuild != null) {
            return previousBuild.getResult() != Result.SUCCESS ? STILL_BROKEN : BROKEN;
        }
        return BROKEN;
    }
}

