/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.jenkins.plugins.buildnotifications;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import tools.devnull.jenkins.plugins.buildnotifications.BaseNotifier;
import tools.devnull.jenkins.plugins.buildnotifications.BotecoMessage;
import tools.devnull.jenkins.plugins.buildnotifications.Message;

public class BotecoNotifier
extends BaseNotifier {
    @DataBoundConstructor
    public BotecoNotifier(String globalTarget, String successfulTarget, String brokenTarget, String stillBrokenTarget, String fixedTarget, boolean sendIfSuccess) {
        super(globalTarget, successfulTarget, brokenTarget, stillBrokenTarget, fixedTarget, sendIfSuccess);
    }

    @Override
    protected Message createMessage(String target, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        BotecoDescriptor descriptor = (BotecoDescriptor)this.getDescriptor();
        return new BotecoMessage(target, descriptor.endpoint);
    }

    @Extension
    public static class BotecoDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String endpoint;

        public BotecoDescriptor() {
            this.load();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            JSONObject config = json.getJSONObject("boteco");
            this.endpoint = config.getString("endpoint");
            this.save();
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Boteco Notification";
        }
    }
}

