/*
 * Decompiled with CFR 0.152.
 */
package tools.devnull.boteco.persistence.user;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.bson.conversions.Bson;
import tools.devnull.boteco.InvalidDestinationException;
import tools.devnull.boteco.MessageLocation;
import tools.devnull.boteco.persistence.user.BotecoUser;
import tools.devnull.boteco.plugins.user.spi.UserRepository;
import tools.devnull.boteco.user.User;
import tools.devnull.boteco.user.UserAlreadyExistException;

public class MongoUserRepository
implements UserRepository {
    private final MongoCollection<Document> users;
    private final Gson gson;

    public MongoUserRepository(MongoDatabase database) {
        this.users = database.getCollection("users");
        this.gson = new Gson();
    }

    public User find(MessageLocation destination) {
        Document document = (Document)this.users.find((Bson)new BasicDBObject("destinations." + destination.channel(), (Object)destination.target())).first();
        if (document != null) {
            return (User)this.gson.fromJson(document.toJson(), BotecoUser.class);
        }
        return null;
    }

    public User find(String userId) {
        Document document = (Document)this.users.find((Bson)new BasicDBObject("_id", (Object)userId)).first();
        if (document != null) {
            return (User)this.gson.fromJson(document.toJson(), BotecoUser.class);
        }
        return null;
    }

    public User create(String userId, MessageLocation primaryDestination) {
        if (this.find(userId) != null) {
            throw new UserAlreadyExistException("User " + userId + " already exists");
        }
        if (this.find(primaryDestination) != null) {
            throw new InvalidDestinationException("Destination already registered");
        }
        BotecoUser user = new BotecoUser(userId, primaryDestination);
        this.users.insertOne((Object)Document.parse((String)this.gson.toJson((Object)user)));
        return user;
    }

    public void update(User user) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)user.id());
        Document update = Document.parse((String)this.gson.toJson((Object)user));
        update.remove((Object)"_id");
        this.users.updateOne((Bson)query, (Bson)new Document("$set", (Object)update));
    }
}

