/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.parallel;

import com.alexbarter.lib.CollectionUtil;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tools.cipher.lib.parallel.WorkerThread;

public class MasterThread
extends Thread {
    public static final IShutdownCondition NONE = () -> false;
    public final LinkedBlockingQueue<Runnable> jobs = new LinkedBlockingQueue(100000);
    private final ThreadGroup threadGroup = new ThreadGroup("job-queue");
    private final Set<WorkerThread> workers = new LinkedHashSet<WorkerThread>();
    private final Consumer<MasterThread> jobProvider;
    private IErrorHandler errorHandler;
    private volatile boolean finishedAddingJobs = false;
    private volatile boolean terminated = false;

    public MasterThread(Consumer<MasterThread> jobProvider) {
        this(Runtime.getRuntime().availableProcessors(), jobProvider);
    }

    public MasterThread(int numThreads, Consumer<MasterThread> jobProvider) {
        if (numThreads < 1 || jobProvider == null) {
            throw new IllegalArgumentException();
        }
        this.jobProvider = jobProvider;
        for (int i = 0; i < numThreads; ++i) {
            this.workers.add(new WorkerThread(this, this.threadGroup));
        }
    }

    public MasterThread setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public void run() {
        this.workers.forEach(Thread::start);
        this.jobProvider.accept(this);
        this.finishedAddingJobs = true;
    }

    public Status tryAddJob(Runnable job, long sleep) {
        Status status = null;
        while ((status = this.addJob(job)).retry()) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return status;
    }

    public Status addJob(Runnable job) {
        if (this.finishedAddingJobs || this.terminated) {
            return Status.END;
        }
        if (this.jobs.remainingCapacity() == 0) {
            return Status.RETRY;
        }
        if (!this.jobs.add(job)) {
            return Status.FAIL;
        }
        return Status.SUCCESS;
    }

    @Nullable
    public Runnable getJob() {
        return this.jobs.poll();
    }

    public boolean hasFinishedAddedJobs() {
        return this.finishedAddingJobs;
    }

    public boolean terminated() {
        return this.terminated;
    }

    public boolean completed() {
        return (this.terminated || this.finishedAddingJobs) && this.jobs.isEmpty() && CollectionUtil.noneMatch(this.workers, WorkerThread::hasJobRunning);
    }

    public void shutdown() {
        this.terminated = true;
        this.finishedAddingJobs = true;
        this.jobs.clear();
    }

    public boolean waitTillCompleted(IShutdownCondition condition) {
        while (!this.completed()) {
            if (this.hasError() || condition.shouldShutdown()) {
                this.shutdown();
            }
            try {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.hasError()) {
            if (this.errorHandler != null) {
                this.errorHandler.onError(this);
            }
            return true;
        }
        return false;
    }

    private boolean hasError() {
        return CollectionUtil.anyMatch(this.workers, WorkerThread::hasError);
    }

    public List<Exception> getErrors() {
        return this.workers.stream().filter(WorkerThread::hasError).map(WorkerThread::getError).collect(Collectors.toList());
    }

    public static IErrorHandler defaultErrorHandler(PrintStream out) {
        return control -> {
            List<Exception> errors = control.getErrors();
            out.println(String.format("Child thread errored, num errors: %d", errors.size()));
            errors.get(0).printStackTrace(out);
        };
    }

    public static enum Status {
        RETRY,
        END,
        FAIL,
        SUCCESS;


        public boolean retry() {
            return this == RETRY;
        }

        public boolean end() {
            return this == END;
        }
    }

    @FunctionalInterface
    public static interface IShutdownCondition {
        public boolean shouldShutdown();
    }

    @FunctionalInterface
    public static interface IErrorHandler {
        public void onError(MasterThread var1);
    }
}

