/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.fitness;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import tools.cipher.lib.file.FileReader;
import tools.cipher.lib.fitness.NGramData;
import tools.cipher.lib.language.ILanguage;

public class TextFitness {
    public static double scoreFitnessQuadgrams(String text, ILanguage language) {
        return TextFitness.scoreFitnessQuadgrams(text.toCharArray(), language);
    }

    public static double scoreFitnessQuadgrams(char[] text, ILanguage language) {
        NGramData quadgramData = language.getQuadgramData();
        double fitness = 0.0;
        for (int k = 0; k < text.length - 4 + 1; ++k) {
            fitness += TextFitness.scoreWord(text, k, quadgramData);
        }
        return fitness;
    }

    public static double scoreFitness(char[] text, NGramData ngramData) {
        double fitness = 0.0;
        for (int k = 0; k < text.length - ngramData.getLength() + 1; ++k) {
            fitness += TextFitness.scoreWord(text, k, ngramData);
        }
        return fitness;
    }

    public static double scoreWord(char[] s, int startIndex, NGramData nGramData) {
        return nGramData.getValue(s, startIndex);
    }

    public static double getEstimatedFitness(String text, ILanguage language) {
        return TextFitness.getEstimatedFitness(text.length(), language.getQuadgramData());
    }

    public static double getEstimatedFitness(int length, NGramData nGramData) {
        return nGramData.getAverageFitness() * (double)Math.max(0, length - nGramData.getLength() + 1);
    }

    public static NGramData loadFile(String resourcePath) {
        NGramReader reader = new NGramReader();
        try {
            FileReader.read(resourcePath, reader::readLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Double> mapping = new HashMap<String, Double>();
        BigDecimal fitnessPerChar = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> rawEntry : reader.entries()) {
            BigDecimal doubleD = rawEntry.getValue().divide(reader.getTotal(), 20, RoundingMode.HALF_DOWN);
            double log = Math.log10(doubleD.doubleValue());
            mapping.put(rawEntry.getKey(), Math.log10(doubleD.doubleValue()));
            fitnessPerChar = fitnessPerChar.add(doubleD.multiply(BigDecimal.valueOf(log)));
        }
        double floor = Math.log10(BigDecimal.valueOf(0.01).divide(reader.getTotal(), 20, RoundingMode.HALF_DOWN).doubleValue());
        System.out.println("Sucessfully loaded ngrams from " + resourcePath);
        return new NGramData(mapping, floor, fitnessPerChar.doubleValue(), reader.getGramSize());
    }

    private static class NGramReader {
        private final HashMap<String, BigDecimal> mapping = new HashMap();
        private BigDecimal total = BigDecimal.ZERO;
        private int length = -1;

        private NGramReader() {
        }

        public void readLine(String line) {
            String[] str = line.split(" ");
            if (str.length < 2) {
                return;
            }
            String ngram = str[0];
            String countStr = str[1];
            BigDecimal count = new BigDecimal(new BigInteger(countStr));
            this.total = this.total.add(count);
            this.mapping.put(ngram, count);
            if (this.length == -1) {
                this.length = ngram.length();
            } else if (this.length != ngram.length()) {
                throw new IllegalArgumentException("Error loading line: " + line);
            }
        }

        public Set<Map.Entry<String, BigDecimal>> entries() {
            return this.mapping.entrySet();
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public int getGramSize() {
            return this.length;
        }
    }
}

