/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib;

import java.io.File;

public class SystemOS {
    public static OS getPlatform() {
        String systemOs = System.getProperty("os.name").toLowerCase();
        if (systemOs.contains("win")) {
            return OS.WINDOWS;
        }
        if (systemOs.contains("mac")) {
            return OS.MACOS;
        }
        if (systemOs.contains("solaris") || systemOs.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (systemOs.contains("linux") || systemOs.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static File getMyDataFolder(String module) {
        File appdataFolder = SystemOS.getAppdataFolder();
        File localFile = new File(appdataFolder, "percivalalb/" + module + "/");
        if (!localFile.exists() && !localFile.mkdirs()) {
            throw new RuntimeException("The module directory could not be created: " + localFile);
        }
        return localFile;
    }

    public static File getAppdataFolder() {
        File localFile;
        String userHome = System.getProperty("user.home", ".");
        switch (SystemOS.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                localFile = new File(userHome);
                break;
            }
            case WINDOWS: {
                String appdata = System.getenv("APPDATA");
                String finalPath = appdata != null ? appdata : userHome;
                localFile = new File(finalPath);
                break;
            }
            case MACOS: {
                localFile = new File(userHome, "Library/Application Support");
                break;
            }
            default: {
                localFile = new File(userHome);
            }
        }
        if (!localFile.exists() && !localFile.mkdirs()) {
            throw new RuntimeException("The appdata directory could not be created: " + localFile);
        }
        return localFile;
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

