/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.registry;

import com.alexbarter.ciphertool.lib.ClassDiscoverer;
import com.alexbarter.ciphertool.lib.registry.IRegistry;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Registry<K, T>
implements IRegistry<K, T> {
    @Nullable
    private final Class<K> keyType;
    @Nullable
    private final Class<T> type;
    private String registryName;
    private Map<K, T> map;
    private int maxSize;
    private Optional<T> fallback;
    private Optional<IRegistry.INamingScheme<K, T>> namingScheme;
    private Optional<ValueValidation<K, T>> validation;
    private Optional<AddCallback<K, T>> addCallback;
    private Optional<RemoveCallback<K, T>> removeCallback;
    private boolean frozen = false;

    private Registry(Class<K> keyType, Class<T> type, Supplier<Map<K, T>> mapSupplier) {
        this.keyType = keyType;
        this.type = type;
        this.map = mapSupplier.get();
        this.maxSize = Integer.MAX_VALUE;
        this.fallback = Optional.empty();
        this.namingScheme = Optional.empty();
        this.validation = Optional.empty();
        this.addCallback = Optional.empty();
        this.removeCallback = Optional.empty();
    }

    @Override
    public boolean register(@Nonnull K key, T value) {
        if (this.validation.isPresent() && !this.validation.get().isValid(key, value)) {
            System.err.println(this.validation.get().getErrorMessage(key, value));
            return false;
        }
        if (this.contains(key)) {
            System.err.println("Already contains key: " + key);
            return false;
        }
        if (this.size() >= this.maxSize) {
            System.err.println("Exceeded max size.");
            return false;
        }
        this.map.put(key, value);
        this.addCallback.ifPresent(callback -> callback.onAdd(key, value));
        System.out.println("Registered " + key + " to '" + this.getRegistryName() + "' registry.");
        return true;
    }

    @Override
    public T get(K key) {
        if (this.contains(key)) {
            return this.map.get(key);
        }
        return this.fallback.orElse(null);
    }

    @Override
    public boolean remove(K key) {
        if (this.contains(key)) {
            Object value = this.map.remove(key);
            this.removeCallback.ifPresent(callback -> callback.onRemove(key, value));
            System.out.println("Removed " + key + " from '" + this.getRegistryName() + "' registry.");
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public IRegistry.INamingScheme<K, T> getNamingScheme() {
        return this.namingScheme.orElseGet(null);
    }

    @Override
    public String getRegistryName() {
        return this.registryName;
    }

    @Override
    public Stream<K> getKeys(T value) {
        return this.map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey);
    }

    @Override
    public Collection<K> getKeys() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> getValues() {
        return this.map.values();
    }

    @Override
    public Collection<Map.Entry<K, T>> getEntries() {
        return this.map.entrySet();
    }

    @Override
    public boolean contains(@Nonnull K key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void freeze() {
        this.map = Collections.unmodifiableMap(this.map);
        this.frozen = true;
    }

    @Override
    public boolean frozen() {
        return this.frozen;
    }

    @Override
    @Nullable
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.type;
    }

    public static <K, U> Builder<K, U> builderNull() {
        return Registry.builder(null, null);
    }

    public static <U> Builder<String, U> builder() {
        return Registry.builder(null);
    }

    public static <U> Builder<String, U> builder(Class<U> type) {
        return new Builder<String, U>(String.class, type).setNamingScheme((reg, value) -> value.getClass().getSimpleName().toLowerCase());
    }

    public static <K, U> Builder<K, U> builder(Class<K> keyType, Class<U> type) {
        return new Builder<K, U>(keyType, type);
    }

    public static class Builder<K, T> {
        private Class<K> keyType;
        private Class<T> type;
        private Supplier<Map<K, T>> mapSupplier = HashMap::new;
        private Optional<String> registryName = Optional.empty();
        private Optional<Integer> maxSize = Optional.empty();
        private Optional<T> fallback = Optional.empty();
        private Optional<Function<T, K>> namingScheme = Optional.empty();
        private Optional<IRegistry.INamingScheme<K, T>> namingSchemeFull = Optional.empty();
        private Optional<ValueValidation<K, T>> validation = Optional.empty();
        private Optional<AddCallback<K, T>> addCallback = Optional.empty();
        private Optional<RemoveCallback<K, T>> removeCallback = Optional.empty();
        private boolean autoDiscover = false;
        private Optional<Class<? extends Annotation>> annotationAutoDisco = Optional.empty();

        public Builder(Class<K> keyType, Class<T> typeIn) {
            this.keyType = keyType;
            this.type = typeIn;
        }

        public final Builder<K, T> setMapType(Supplier<Map<K, T>> mapSupplier) {
            this.mapSupplier = mapSupplier;
            return this;
        }

        public final Builder<K, T> setRegistryName(String registryName) {
            this.registryName = Optional.of(registryName);
            return this;
        }

        public final Builder<K, T> setMaxSize(int sizeIn) {
            if (sizeIn < 0) {
                throw new IllegalArgumentException("Size should non-negative");
            }
            this.maxSize = Optional.of(sizeIn);
            return this;
        }

        public final Builder<K, T> setFallback(@Nonnull T fallback) {
            this.fallback = Optional.of(fallback);
            return this;
        }

        public final Builder<K, T> setNamingScheme(Function<T, K> scheme) {
            this.namingScheme = Optional.of(scheme);
            this.namingSchemeFull = Optional.empty();
            return this;
        }

        public final Builder<K, T> setNamingScheme(IRegistry.INamingScheme<K, T> scheme) {
            this.namingSchemeFull = Optional.of(scheme);
            this.namingScheme = Optional.empty();
            return this;
        }

        public final Builder<K, T> addValidation(ValueValidation<K, T> validation) {
            this.validation = Optional.of(validation);
            return this;
        }

        public final Builder<K, T> setAddCallback(AddCallback<K, T> callback) {
            this.addCallback = Optional.of(callback);
            return this;
        }

        public final Builder<K, T> setRemoveCallback(RemoveCallback<K, T> callback) {
            this.removeCallback = Optional.of(callback);
            return this;
        }

        public final Builder<K, T> setAutoDiscover() {
            this.autoDiscover = true;
            return this;
        }

        public final Builder<K, T> setDiscoverAnnotation(Class<? extends Annotation> annotationClass) {
            this.annotationAutoDisco = Optional.of(annotationClass);
            return this;
        }

        public final Registry<K, T> build() {
            Registry target = new Registry(this.keyType, this.type, this.mapSupplier);
            target.registryName = this.registryName.orElse(this.type != null ? this.type.getSimpleName() : "Unknown");
            this.maxSize.ifPresent(s -> target.maxSize = s);
            this.fallback.ifPresent(f -> target.fallback = Optional.of(f));
            this.namingScheme.ifPresent(f -> target.namingScheme = Optional.of((reg, value) -> f.apply(value)));
            this.namingSchemeFull.ifPresent(f -> target.namingScheme = Optional.of(f));
            this.validation.ifPresent(v -> target.validation = Optional.of(v));
            this.addCallback.ifPresent(c -> target.addCallback = Optional.of(c));
            this.removeCallback.ifPresent(c -> target.removeCallback = Optional.of(c));
            if (this.autoDiscover) {
                if (this.type != null) {
                    ClassDiscoverer.getInstances("nationalcipher", this.annotationAutoDisco.orElse(null), this.type).stream().forEach(target::register);
                } else {
                    System.err.println("Cannot auto discover as target class is null.");
                }
            }
            return target;
        }
    }

    @FunctionalInterface
    public static interface ValueValidation<K, T> {
        public boolean isValid(K var1, T var2);

        default public String getErrorMessage(K key, T value) {
            return "Unable to add " + key;
        }
    }

    @FunctionalInterface
    public static interface RemoveCallback<K, T> {
        public void onRemove(@Nonnull K var1, T var2);
    }

    @FunctionalInterface
    public static interface AddCallback<K, T> {
        public void onAdd(@Nonnull K var1, T var2);
    }
}

