/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib;

import com.alexbarter.ciphertool.lib.ArrayUtil;
import com.alexbarter.ciphertool.lib.characters.CharSequenceUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CipherUtils {
    private static final NumberFormat numFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public static Map<Character, Integer> createCharacterIndexMapping(CharSequence key) {
        HashMap<Character, Integer> keyIndex = new HashMap<Character, Integer>();
        for (int i = 0; i < key.length(); ++i) {
            keyIndex.put(Character.valueOf(key.charAt(i)), i);
        }
        return keyIndex;
    }

    public static byte getAlphaIndex(char alphaChar) {
        if ('A' <= alphaChar && alphaChar <= 'Z') {
            return (byte)(alphaChar - 65);
        }
        if ('a' <= alphaChar && alphaChar <= 'z') {
            return (byte)(alphaChar - 97);
        }
        return -1;
    }

    public static byte[] charSeqToByteArray(CharSequence input) {
        byte[] output = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            output[i] = (byte)input.charAt(i);
        }
        return output;
    }

    public static String byteArrayToCharSeq(byte[] input) {
        return new String(input, Charset.forName("UTF-8"));
    }

    public static String formatBigInteger(BigInteger value) {
        return numFormatter.format(value);
    }

    public static String displayAsLetters(Integer[] array) {
        StringBuilder builder = new StringBuilder(array.length);
        for (int i = 0; i < array.length; ++i) {
            builder.append((char)(array[i] + 65));
        }
        return builder.toString();
    }

    public static <K> void recussivelyIterate(Object key, Consumer<List<Object>> accept, BiConsumer<Object, Consumer> ... lists) {
        if (lists.length == 0) {
            return;
        }
        ArrayList list = new ArrayList();
        Consumer<Consumer> consumer = func -> {};
        BiConsumer<Object, Consumer> consumer3 = (o, c) -> {
            list.add(c);
            accept.accept(list);
            list.clear();
        };
        int i = lists.length - 2;
        while (i >= 0) {
            BiConsumer<Object, Consumer> consumer2 = consumer3;
            int j = i--;
            consumer3 = (o, c) -> lists[j].accept(key, n -> {
                list.add(n);
                consumer2.accept(key, null);
            });
        }
        consumer3.accept(null, null);
    }

    public static String genKeySquare(String keyword, CharSequence alphabet) {
        int i;
        char[] builder = new char[alphabet.length()];
        int index = 0;
        for (i = 0; i < keyword.length(); ++i) {
            if (!CharSequenceUtils.contains(alphabet, keyword.charAt(i)) || ArrayUtil.contains((char[])builder, (int)0, (int)index, (char)keyword.charAt(i))) continue;
            builder[index++] = keyword.charAt(i);
        }
        for (i = 0; i < alphabet.length(); ++i) {
            char ch = alphabet.charAt(i);
            int keyindex = keyword.indexOf(ch);
            if (keyindex != -1) continue;
            builder[index++] = ch;
        }
        return new String(builder);
    }
}

