/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.language;

import com.alexbarter.ciphertool.lib.Cache;
import com.alexbarter.ciphertool.lib.fitness.NGramData;
import com.alexbarter.ciphertool.lib.language.Dictionary;
import com.alexbarter.ciphertool.lib.language.LanguageUtils;
import com.alexbarter.lib.util.MathUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ILanguage {
    private final Cache<Double> minFrequency = Cache.create(() -> (Double)MathUtil.getSmallest(this.getLetterFrequency().values()));
    private final Cache<Double> maxFrequency = Cache.create(() -> (Double)MathUtil.getBiggest(this.getLetterFrequency().values()));
    private final Cache<List<Character>> sortedCharacters = Cache.create(() -> this.getLetterFrequency().entrySet().stream().sorted(new LetterFrequencyComparator()).map(Map.Entry::getKey).collect(Collectors.toList()));
    private final Cache<List<Double>> sortedFrequency = Cache.create(() -> this.getLetterFrequency().entrySet().stream().sorted(new LetterFrequencyComparator()).map(Map.Entry::getValue).collect(Collectors.toList()));
    private final Cache<List<Character>> sortedCharactersReverse = Cache.create(() -> this.getLetterFrequency().entrySet().stream().sorted(new LetterFrequencyComparator().reversed()).map(Map.Entry::getKey).collect(Collectors.toList()));
    private final Cache<List<Double>> sortedFrequencyReverse = Cache.create(() -> this.getLetterFrequency().entrySet().stream().sorted(new LetterFrequencyComparator().reversed()).map(Map.Entry::getValue).collect(Collectors.toList()));
    private final Cache<Double> normalisedIC = Cache.create(() -> LanguageUtils.calculateNormalisedIC(this.getLetterFrequency().values()));
    private final Cache<Map<Character, Double>> frequencyMap = Cache.create(() -> Collections.unmodifiableMap(this.addLetterFrequencies(new HashMap<Character, Double>())));

    public abstract Map<Character, Double> addLetterFrequencies(Map<Character, Double> var1);

    public Map<Character, Double> getLetterFrequency() {
        return this.frequencyMap.get();
    }

    public double getFrequencyOfLetter(char character) {
        return this.getLetterFrequency().get(Character.valueOf(character));
    }

    public List<Character> getLetterLargestFirst() {
        return this.sortedCharactersReverse.get();
    }

    public List<Character> getLetterSmallestFirst() {
        return this.sortedCharacters.get();
    }

    public List<Double> getFrequencyLargestFirst() {
        return this.sortedFrequencyReverse.get();
    }

    public List<Double> getFrequencySmallestFirst() {
        return this.sortedFrequency.get();
    }

    public double getMaxFrequency() {
        return this.maxFrequency.get();
    }

    public double getMinFrequency() {
        return this.minFrequency.get();
    }

    public void clearCache() {
        this.frequencyMap.release();
        this.minFrequency.release();
        this.maxFrequency.release();
        this.sortedCharacters.release();
        this.sortedFrequency.release();
        this.sortedCharactersReverse.release();
        this.sortedFrequencyReverse.release();
        this.normalisedIC.release();
    }

    public abstract void loadNGramData();

    public abstract NGramData getQuadgramData();

    public abstract NGramData getDiagramData();

    public NGramData getTrigramData() {
        return null;
    }

    public Dictionary getDictionary() {
        return null;
    }

    public double getNormalisedIC() {
        return this.normalisedIC.get();
    }

    public abstract String getName();

    public abstract String getImagePath();

    private class LetterFrequencyComparator
    implements Comparator<Map.Entry<Character, Double>> {
        private LetterFrequencyComparator() {
        }

        @Override
        public int compare(Map.Entry<Character, Double> o1, Map.Entry<Character, Double> o2) {
            return Double.compare(o1.getValue(), o2.getValue());
        }
    }
}

