/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib.math;

import com.alexbarter.ciphertool.lib.math.SimultaneousEquationExpection;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.ciphertool.lib.matrix.MatrixNoInverse;

public class SimultaneousEquations {
    public static Integer[] solve(Integer[][] simEquations, int mod) throws SimultaneousEquationExpection {
        int UNKNOWNS = simEquations.length;
        Matrix matrix = new Matrix((r, c) -> simEquations[r][c], UNKNOWNS, UNKNOWNS);
        Matrix invMatrix = null;
        try {
            invMatrix = matrix.inverseMod(mod);
        }
        catch (MatrixNoInverse e) {
            throw new SimultaneousEquationExpection("No exact solution to simulation equations");
        }
        Matrix equalsMatrix = new Matrix((r, c) -> simEquations[r][UNKNOWNS], UNKNOWNS, 1);
        return invMatrix.multiply((Matrix)equalsMatrix).modular((int)mod).data;
    }

    private static Integer[] solve(Integer[][] simEquations) throws SimultaneousEquationExpection {
        int UNKNOWNS = simEquations.length;
        Matrix matrix = new Matrix((r, c) -> simEquations[r][c], UNKNOWNS, UNKNOWNS);
        Matrix invMatrix = null;
        try {
            invMatrix = matrix.inverse();
        }
        catch (MatrixNoInverse e) {
            throw new SimultaneousEquationExpection("No exact solution to simulation equations");
        }
        Matrix equalsMatrix = new Matrix((r, c) -> simEquations[r][UNKNOWNS], UNKNOWNS, 1);
        return invMatrix.multiply((Matrix)equalsMatrix).data;
    }
}

