/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.identify;

import tools.cipher.identify.StatCalculator;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.util.VigenereType;

public class StatsTest {
    public static double calculateSubTypeLDI(String text, VigenereType type, ILanguage language) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        double largestSum = 0.0;
        for (int period = 2; period <= 15; ++period) {
            double sum = 0.0;
            for (int col = 0; col < period; ++col) {
                sum += StatsTest.best_di(text, period, col, type, language);
            }
            largestSum = Math.min(largestSum, sum /= (double)period);
        }
        return largestSum;
    }

    public static double best_di(String text, int period, int col, VigenereType type, ILanguage language) {
        double bestScore = 0.0;
        int rows = (int)Math.ceil(text.length() / period);
        for (char keyLeft = 'A'; keyLeft <= 'Z'; keyLeft = (char)((char)(keyLeft + 1))) {
            for (char keyRight = 'A'; keyRight <= 'Z'; keyRight = (char)((char)(keyRight + 1))) {
                double score = 0.0;
                int ct = 0;
                char kl1 = keyLeft;
                char kr1 = keyRight;
                for (int r = 0; r < rows && col + r * period + 1 < text.length(); ++r) {
                    char pl = type.decode(text.charAt(col + r * period), kl1);
                    char pr = type.decode(text.charAt(col + r * period + 1), kr1);
                    score += language.getDiagramData().getMaxValue() - language.getDiagramData().getValue(new char[]{pl, pr}, 0);
                    ++ct;
                }
                if (ct == 0) {
                    return 0.0;
                }
                score *= 100.0;
                if (!((score /= (double)ct) < bestScore)) continue;
                bestScore = score;
            }
        }
        return bestScore;
    }
}

