/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.identify;

import com.alexbarter.ciphertool.lib.characters.CharacterCount;
import com.alexbarter.ciphertool.lib.characters.StringUtils;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.ciphertool.lib.stats.StatIC;
import com.alexbarter.lib.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class StatCalculator {
    static int[][] sdd = new int[][]{{0, 3, 4, 2, 0, 0, 1, 0, 0, 0, 4, 5, 2, 6, 0, 2, 0, 4, 4, 3, 0, 6, 0, 0, 3, 5}, {0, 0, 0, 0, 6, 0, 0, 0, 0, 9, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 7, 0}, {3, 0, 0, 0, 2, 0, 0, 6, 0, 0, 8, 0, 0, 0, 6, 0, 5, 0, 0, 0, 3, 0, 0, 0, 0, 0}, {1, 6, 0, 0, 1, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 4, 0, 1, 0}, {0, 0, 4, 5, 0, 0, 0, 0, 0, 3, 0, 0, 3, 2, 0, 3, 6, 5, 4, 0, 0, 4, 3, 8, 0, 0}, {3, 0, 0, 0, 0, 5, 0, 0, 2, 1, 0, 0, 0, 0, 5, 0, 0, 2, 0, 4, 1, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 0, 0, 6, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 2, 0, 0, 0, 0, 0}, {5, 0, 0, 0, 7, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 5, 0, 0, 0, 4, 0, 0, 0, 1, 1, 3, 7, 0, 0, 0, 0, 5, 3, 0, 5, 0, 0, 0, 8}, {0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 6, 0, 0, 0, 5, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {2, 0, 0, 4, 2, 0, 0, 0, 3, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0}, {5, 5, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 6, 0, 0, 0, 0, 2, 0, 0, 0, 6, 0}, {0, 0, 4, 7, 0, 0, 8, 0, 0, 2, 2, 0, 0, 0, 0, 0, 3, 0, 0, 4, 0, 0, 0, 0, 0, 0}, {0, 2, 0, 0, 0, 8, 0, 0, 0, 0, 4, 0, 5, 5, 0, 2, 0, 4, 0, 0, 7, 4, 5, 0, 0, 0}, {3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 5, 0, 0, 5, 7, 0, 6, 0, 0, 3, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 4, 0, 0, 0, 2, 0, 4, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0}, {1, 1, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 1, 4, 4, 0, 1, 4, 2, 0, 4, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0}, {0, 4, 3, 0, 0, 0, 5, 0, 0, 0, 0, 6, 2, 3, 0, 6, 0, 6, 5, 3, 0, 0, 0, 0, 0, 6}, {0, 0, 0, 0, 8, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 0, 0, 0, 2, 0, 0, 6, 6, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 0, 7, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 5, 0, 0, 0, 6, 0, 0}, {1, 6, 2, 0, 0, 2, 0, 0, 0, 6, 0, 0, 2, 0, 6, 2, 1, 0, 2, 1, 0, 0, 6, 0, 0, 0}, {2, 0, 0, 0, 8, 0, 0, 0, 0, 6, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9}};
    public static int[] bstd = new int[17580];

    public static double calculateMaxIC(String text, int minPeriod, int maxPeriod) {
        double maxIC = 0.0;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            double totalIOC = 0.0;
            for (int i = 0; i < period; ++i) {
                totalIOC += StatCalculator.calculateIC(StringUtils.getEveryNthChar((CharSequence)text, (int)i, (int)period), 1, true);
            }
            maxIC = Math.max(maxIC, totalIOC / (double)period);
        }
        return maxIC;
    }

    public static double calculateIC(CharSequence text, int length, boolean overlap) {
        return StatIC.calculate((CharSequence)text, (int)length, (boolean)overlap);
    }

    public static double calculateMonoIC(char[] text) {
        return StatIC.calculateMonoIC((char[])text);
    }

    public static double calculateKappaIC(String text, int period) {
        return StatCalculator.calculateKappaIC((CharSequence)text, StringUtils.rotateRight((CharSequence)text, (int)period));
    }

    private static double calculateKappaIC(CharSequence text1, String text2) {
        double coincidence = 0.0;
        for (int i = 0; i < text1.length(); ++i) {
            if (text1.charAt(i) != text2.charAt(i)) continue;
            coincidence += 1.0;
        }
        return coincidence / (double)text1.length();
    }

    public static double calculateMaxKappaIC(String text, int minPeriod, int maxPeriod) {
        if (text.length() == 0) {
            return 0.0;
        }
        double maxKappa = Double.MIN_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            maxKappa = Math.max(maxKappa, StatCalculator.calculateKappaIC(text, period));
        }
        return maxKappa;
    }

    public static double calculateMinKappaIC(String text, int minPeriod, int maxPeriod) {
        double minKappa = Double.MAX_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            minKappa = Math.min(minKappa, StatCalculator.calculateKappaIC(text, period));
        }
        return minKappa;
    }

    public static int calculateBestKappaIC(String text, int minPeriod, int maxPeriod, ILanguage language) {
        int bestPeriod = -1;
        double bestKappa = Double.MAX_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            double sqDiff = Math.pow(StatCalculator.calculateKappaIC(text, period) - language.getNormalisedIC(), 2.0);
            if (sqDiff < bestKappa) {
                bestPeriod = period;
            }
            bestKappa = Math.min(bestKappa, sqDiff);
        }
        return bestPeriod;
    }

    public static double calculateDiagraphicKappaIC(String text, int period) {
        return StatCalculator.calculateDiagraphicKappaIC(text, StringUtils.rotateRight((CharSequence)text, (int)period));
    }

    private static double calculateDiagraphicKappaIC(String text1, String text2) {
        double coincidence = 0.0;
        for (int j = 0; j < text1.length(); j += 2) {
            if (!text1.substring(j, j + 2).equals(text2.substring(j, j + 2))) continue;
            coincidence += 1.0;
        }
        return coincidence / (double)(text1.length() / 2);
    }

    public static double calculateMaxDiagraphicKappaIC(String text, int minPeriod, int maxPeriod) {
        double maxKappa = Double.MIN_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            maxKappa = Math.max(maxKappa, StatCalculator.calculateDiagraphicKappaIC(text, period));
        }
        return maxKappa * 1000.0;
    }

    public static double calculateMinDiagraphicKappaIC(String text, int minPeriod, int maxPeriod) {
        double minKappa = Double.MAX_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            minKappa = Math.min(minKappa, StatCalculator.calculateDiagraphicKappaIC(text, period));
        }
        return minKappa * 1000.0;
    }

    public static int calculateBestDiagraphicKappaIC(String text, int minPeriod, int maxPeriod, ILanguage language) {
        int bestPeriod = -1;
        double bestKappa = Double.POSITIVE_INFINITY;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            double sqDiff = Math.pow(StatCalculator.calculateDiagraphicKappaIC(text, period) - language.getNormalisedIC(), 2.0);
            if (sqDiff < bestKappa) {
                bestPeriod = period;
            }
            bestKappa = Math.min(bestKappa, sqDiff);
        }
        return bestPeriod;
    }

    public static double calculateBifidDiagraphicIC(String text, int period) {
        if (period == 0) {
            period = text.length();
        }
        HashMap<String, Integer> theatricalDiagram = new HashMap<String, Integer>();
        int count = 0;
        for (int i = 0; i < text.length(); i += period) {
            int columns = Math.min(period / 2, (text.length() - i) / 2);
            int limit = Math.min(i + period, text.length());
            for (int j = i; j < limit - columns; ++j) {
                String theatrical;
                theatricalDiagram.put(theatrical, 1 + (theatricalDiagram.containsKey(theatrical = text.charAt(j) + "" + text.charAt(j + columns)) ? (Integer)theatricalDiagram.get(theatrical) : 0));
            }
            count += limit - columns - i;
        }
        double sum = 0.0;
        for (String diagram : theatricalDiagram.keySet()) {
            sum += (double)((Integer)theatricalDiagram.get(diagram) * ((Integer)theatricalDiagram.get(diagram) - 1));
        }
        return 62500.0 * sum / (double)(count * (count - 1));
    }

    public static double calculateTrifidDiagraphicIC(String text, int period) {
        if (period == 0) {
            period = text.length();
        }
        HashMap<String, Integer> theatricalDiagram = new HashMap<String, Integer>();
        int count = 0;
        for (int i = 0; i < text.length(); i += period) {
            int columns = Math.min(period / 3, (text.length() - i) / 3);
            int limit = Math.min(i + period, text.length());
            for (int j = i; j < limit - columns * 2; ++j) {
                String theatrical;
                theatricalDiagram.put(theatrical, 1 + (theatricalDiagram.containsKey(theatrical = text.charAt(j) + "" + text.charAt(j + columns) + "" + text.charAt(j + columns * 2)) ? (Integer)theatricalDiagram.get(theatrical) : 0));
            }
            count += limit - columns * 2 - i;
        }
        double sum = 0.0;
        for (String diagram : theatricalDiagram.keySet()) {
            sum += (double)((Integer)theatricalDiagram.get(diagram) * ((Integer)theatricalDiagram.get(diagram) - 1));
        }
        return 1968300.0 * sum / (double)(count * (count - 1));
    }

    public static double calculateStrangeIC(String text, int period, int size, int uniqueChars) {
        if (period == 0) {
            period = text.length();
        }
        HashMap<String, Integer> theatricalDiagram = new HashMap<String, Integer>();
        int count = 0;
        for (int i = 0; i < text.length(); i += period) {
            int columns = Math.min(period / size, (text.length() - i) / size);
            int limit = Math.min(i + period, text.length());
            for (int j = i; j < limit - columns * (size - 1); ++j) {
                String theatrical = "";
                for (int s = 0; s < size; ++s) {
                    theatrical = theatrical + text.charAt(j + columns * s);
                }
                theatricalDiagram.put(theatrical, 1 + (theatricalDiagram.containsKey(theatrical) ? (Integer)theatricalDiagram.get(theatrical) : 0));
            }
            count += Math.max(limit - columns * (size - 1) - i, 0);
        }
        double sum = 0.0;
        for (String diagram : theatricalDiagram.keySet()) {
            sum += (double)((Integer)theatricalDiagram.get(diagram) * ((Integer)theatricalDiagram.get(diagram) - 1));
        }
        return Math.pow(uniqueChars, size) * 100.0 * sum / (double)(count * (count - 1));
    }

    public static double calculateLongIC(String text, int period, int uniqueChars) {
        HashMap<String, Integer> theatricalDiagram = new HashMap<String, Integer>();
        int count = 0;
        for (int i = 0; i < text.length(); i += period) {
            String theatrical;
            theatricalDiagram.put(theatrical, 1 + (theatricalDiagram.containsKey(theatrical = text.substring(i, Math.min(i + period, text.length()))) ? (Integer)theatricalDiagram.get(theatrical) : 0));
            ++count;
        }
        double sum = 0.0;
        for (String diagram : theatricalDiagram.keySet()) {
            sum += (double)((Integer)theatricalDiagram.get(diagram) * ((Integer)theatricalDiagram.get(diagram) - 1));
        }
        return Math.pow(uniqueChars, period) * 100.0 * sum / (double)(count * (count - 1));
    }

    public static double calculateMaxTrifidDiagraphicIC(String text, int minPeriod, int maxPeriod) {
        if (StatCalculator.containsDigit(text)) {
            return 0.0;
        }
        double bestIC = 0.0;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            if (period == 1) continue;
            bestIC = Math.max(bestIC, StatCalculator.calculateTrifidDiagraphicIC(text, period));
        }
        return bestIC;
    }

    public static double calculateMaxBifidDiagraphicIC(String text, int minPeriod, int maxPeriod) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        double bestIC = 0.0;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            if (period == 1) continue;
            bestIC = Math.max(bestIC, StatCalculator.calculateBifidDiagraphicIC(text, period));
        }
        return bestIC;
    }

    public static int calculateBestBifidDiagraphicIC(String text, int minPeriod, int maxPeriod) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return -1;
        }
        int bestPeriod = -1;
        double bestIC = Double.MIN_VALUE;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            if (period == 1) continue;
            double score = StatCalculator.calculateBifidDiagraphicIC(text, period);
            if (bestIC < score) {
                bestPeriod = period;
            }
            bestIC = Math.max(bestIC, score);
        }
        return bestPeriod;
    }

    public static double calculateNicodemusIC(String text, int blockHeight, int period) {
        int[][] counts = new int[period][26];
        int blocksFull = text.length() / (blockHeight * period);
        if (blocksFull == 0) {
            return 0.0;
        }
        int limit = blocksFull * blockHeight * period;
        int index = 0;
        for (int i = 0; i < limit; ++i) {
            int[] nArray = counts[index];
            int n = text.charAt(i) - 65;
            nArray[n] = nArray[n] + 1;
            if ((i + 1) % blockHeight != 0) continue;
            index = (index + 1) % period;
        }
        double sumIC = 0.0;
        for (int i = 0; i < period; ++i) {
            double total = 0.0;
            int n = 0;
            for (int j = 0; j < 26; ++j) {
                double count = counts[i][j];
                total += count * (count - 1.0);
                n = (int)((double)n + count);
            }
            if (n <= true) continue;
            sumIC += total / (double)(n * (n - 1));
        }
        return sumIC / (double)period;
    }

    public static double calculateMaxNicodemusIC(String text, int minPeriod, int maxPeriod) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        double maxIC = Double.NEGATIVE_INFINITY;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            maxIC = Math.max(maxIC, StatCalculator.calculateNicodemusIC(text, 5, period));
        }
        return 1000.0 * maxIC;
    }

    public static int calculateBestNicodemusIC(String text, int minPeriod, int maxPeriod, ILanguage language) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return -1;
        }
        int bestPeriod = -1;
        double bestIC = Double.POSITIVE_INFINITY;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            double sqDiff = Math.pow(StatCalculator.calculateNicodemusIC(text, 5, period) - language.getNormalisedIC(), 2.0);
            if (sqDiff < bestIC) {
                bestPeriod = period;
            }
            bestIC = Math.min(bestIC, sqDiff);
        }
        return bestPeriod;
    }

    public static double calculateNormalOrder(String text, ILanguage language) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        List frequencyLargestLanguage = language.getLetterLargestFirst();
        List frequencyLargestText = CharacterCount.getOrderedCharacters((CharSequence)text);
        double total = 0.0;
        for (int i = 0; i < frequencyLargestLanguage.size(); ++i) {
            char target = ((Character)frequencyLargestLanguage.get(i)).charValue();
            if (frequencyLargestText.contains(Character.valueOf(target))) {
                total += (double)Math.abs(i - frequencyLargestText.indexOf(Character.valueOf(target)));
                continue;
            }
            total += (double)i;
        }
        return total;
    }

    public static double calculateLR(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            for (int j = i + 1; j < text.length(); ++j) {
                int n = 0;
                while (j + n < text.length() && text.charAt(i + n) == text.charAt(j + n) && ++n <= 3) {
                }
                if (n != 3) continue;
                ++count;
            }
        }
        return Math.sqrt(count) / (double)text.length() * 1000.0;
    }

    public static double calculateROD(String text) {
        int sumAll = 0;
        int sumOdd = 0;
        for (int i = 0; i < text.length(); ++i) {
            for (int j = i + 1; j < text.length(); ++j) {
                int n = 0;
                while (j + n < text.length() && text.charAt(i + n) == text.charAt(j + n)) {
                    ++n;
                }
                if (n <= 1) continue;
                ++sumAll;
                if ((j - i & 1) != 1) continue;
                ++sumOdd;
            }
        }
        if (sumAll == 0) {
            return 0.0;
        }
        return 100 * sumOdd / sumAll;
    }

    public static double calculateSDD(String text) {
        double score = 0.0;
        for (int i = 0; i < text.length() - 1; ++i) {
            if (!Character.isLetter(text.charAt(i)) || !Character.isLetter(text.charAt(i + 1))) continue;
            score += (double)sdd[text.charAt(i) - 65][text.charAt(i + 1) - 65];
        }
        return score * 100.0 / (double)(text.length() - 1);
    }

    public static boolean isLengthDivisible2(String text) {
        return text.length() % 2 == 0;
    }

    public static boolean isLengthDivisible3(String text) {
        return text.length() % 3 == 0;
    }

    public static boolean isLengthDivisible5(String text) {
        return text.length() % 5 == 0;
    }

    public static boolean isLengthDivisible25(String text) {
        return text.length() % 25 == 0;
    }

    public static boolean isLengthDivisible4_15(String text) {
        for (int n = 4; n <= 15; ++n) {
            if (text.length() % n != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isLengthDivisible4_30(String text) {
        for (int n = 4; n <= 30; ++n) {
            if (text.length() % n != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isLengthPerfectSquare(String text) {
        int n = (int)Math.floor(Math.sqrt(text.length()));
        return Math.pow(n, 2.0) == (double)text.length();
    }

    public static boolean containsLetter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if ('A' > text.charAt(i) || text.charAt(i) > 'Z') continue;
            return true;
        }
        return false;
    }

    public static boolean containsDigit(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if ('0' > text.charAt(i) || text.charAt(i) > '9') continue;
            return true;
        }
        return false;
    }

    public static boolean containsJ(String text) {
        return text.contains("J");
    }

    public static boolean containsHash(String text) {
        return text.contains("#");
    }

    public static boolean calculateDBL(String text) {
        if (text.length() % 2 == 0) {
            for (int i = 0; i < text.length(); i += 2) {
                if (text.charAt(i) != text.charAt(i + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static double calculatePHIC(String text) {
        int col_len = 5;
        List<Integer> combine_alpha = Arrays.asList(0, 1, 2, 3, 0, 4, 5, 1);
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        int period = 8;
        int[][] ct = new int[period - 2][26];
        for (int i = 0; i < period - 2; ++i) {
            Arrays.fill(ct[i], 0);
        }
        int block_len = (int)Math.floor(text.length() / (col_len * period));
        if (block_len == 0) {
            return 0.0;
        }
        int limit = block_len * col_len * period;
        int index = 0;
        for (int i = 0; i < limit; ++i) {
            int[] nArray = ct[combine_alpha.get(index)];
            int n = text.charAt(i) - 65;
            nArray[n] = nArray[n] + 1;
            if ((i + 1) % col_len != 0) continue;
            index = (index + 1) % period;
        }
        double z = 0.0;
        for (int i = 0; i < period - 2; ++i) {
            double x = 0.0;
            double y = 0.0;
            for (int j = 0; j < 26; ++j) {
                x += (double)(ct[i][j] * (ct[i][j] - 1));
                y += (double)ct[i][j];
            }
            if (!(y > 1.0)) continue;
            z += x / (y * (y - 1.0));
        }
        return Math.floor(1000.0 * (z /= (double)(period - 2)));
    }

    public static boolean calculateHAS0(String text) {
        if (StatCalculator.containsLetter(text) || StatCalculator.containsHash(text)) {
            return false;
        }
        return text.contains("0");
    }

    public static double calculateCDD(String text) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        double best_score = 0.0;
        for (int key_len = 4; key_len <= 15; ++key_len) {
            int j;
            int numb_long_cols = text.length() % key_len;
            int numb_short_cols = key_len - numb_long_cols;
            int numb_rows = (int)Math.floor(text.length() / key_len);
            int[] min_start = new int[key_len];
            int[] max_start = new int[key_len];
            int[] max_diff = new int[key_len];
            int[] col_pos = new int[key_len];
            int[] col_array = new int[key_len];
            boolean[] cols_in_use = new boolean[key_len];
            Arrays.fill(cols_in_use, false);
            int[] diff_array = new int[key_len];
            min_start[0] = 0;
            int n = 0;
            for (j = 1; j < key_len; ++j) {
                if (n < numb_short_cols) {
                    min_start[j] = min_start[j - 1] + numb_rows;
                    ++n;
                    continue;
                }
                min_start[j] = min_start[j - 1] + numb_rows + 1;
            }
            max_diff[0] = 0;
            max_start[0] = 0;
            n = 0;
            for (j = 1; j < key_len; ++j) {
                if (n < numb_long_cols) {
                    max_start[j] = max_start[j - 1] + numb_rows + 1;
                    ++n;
                } else {
                    max_start[j] = max_start[j - 1] + numb_rows;
                }
                max_diff[j] = max_start[j] - min_start[j];
            }
            for (j = 0; j < key_len; ++j) {
                col_pos[j] = min_start[j];
            }
            for (int t0 = 0; t0 < key_len; ++t0) {
                col_array[0] = t0;
                cols_in_use[t0] = true;
                int long_corr = 0;
                if (0 < numb_long_cols && t0 >= numb_long_cols) {
                    long_corr = 1;
                }
                for (int current_dif = 0; current_dif <= max_diff[t0] - long_corr; ++current_dif) {
                    diff_array[0] = current_dif;
                    int index = 1;
                    for (int j2 = 0; j2 < key_len; ++j2) {
                        if (cols_in_use[j2]) continue;
                        col_array[index++] = j2;
                    }
                    double score = 0.0;
                    for (int j3 = 1; j3 < key_len; ++j3) {
                        try {
                            int[] tn = StatCalculator.getBestDI(text, j3, key_len, numb_long_cols, numb_short_cols, numb_rows, col_array, max_diff, col_pos, diff_array);
                            score += (double)tn[0];
                            int swap = col_array[tn[1]];
                            col_array[tn[1]] = col_array[j3];
                            col_array[j3] = swap;
                            diff_array[j3] = tn[2];
                            continue;
                        }
                        catch (Exception e) {
                            return 0.0;
                        }
                    }
                    score = 100.0 * score / (double)(numb_rows * (key_len - 1));
                    best_score = Math.max(best_score, score);
                }
                cols_in_use[t0] = false;
            }
        }
        return Math.floor(best_score);
    }

    public static int[] getBestDI(String text, int col, int key_len, int numb_long_cols, int numb_short_cols, int numb_rows, int[] col_array, int[] max_diff, int[] col_pos, int[] diff_array) {
        int max = 0;
        int next_col = 0;
        int next_dif = 0;
        for (int j = col; j < key_len; ++j) {
            int long_corr = 0;
            int short_corr = 0;
            if (col >= numb_long_cols && col_array[j] >= numb_short_cols) {
                short_corr = 1;
            } else if (col < numb_long_cols && col_array[j] >= numb_long_cols) {
                long_corr = 1;
            }
            for (int dif = short_corr; dif <= max_diff[col_array[j]] - long_corr; ++dif) {
                int sum = 0;
                for (int k = 0; k < numb_rows; ++k) {
                    sum += sdd[text.charAt(col_pos[col_array[col - 1]] + k + diff_array[col - 1]) - 65][text.charAt(col_pos[col_array[j]] + k + dif) - 65];
                }
                if (sum <= max) continue;
                max = sum;
                next_col = j;
                next_dif = dif;
            }
        }
        return new int[]{max, next_col, next_dif};
    }

    public static double calculateSSTD(String text) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        int best_score = 0;
        for (int period = 4; period <= 8; ++period) {
            if (text.length() % period != 0) continue;
            if (3 * period * period > text.length()) break;
            int result = StatCalculator.swagTest(text, period);
            System.out.println(period + " " + result);
            if (result <= best_score) continue;
            best_score = result;
        }
        return best_score;
    }

    public static int swagTest(String text, int period) {
        double score;
        int numbColumns = text.length() / period;
        int[] rowOrder = ArrayUtil.createRange((int)period);
        int[][] swagArray = new int[period][numbColumns];
        int index = 0;
        int i = 0;
        for (int j = 0; j < text.length(); ++j) {
            int c;
            swagArray[i][index] = c = text.charAt(j) - 65;
            if (++i != period) continue;
            ++index;
            i = 0;
        }
        int[] row = StatCalculator.constructRow(rowOrder, swagArray, period, numbColumns);
        double bestScore = score = (double)StatCalculator.scoreRow(row);
        while (true) {
            Object[] per = StatCalculator.next_per(rowOrder, rowOrder.length);
            rowOrder = (int[])per[1];
            if ((Integer)per[0] == 0) break;
            row = StatCalculator.constructRow(rowOrder, swagArray, period, numbColumns);
            score = StatCalculator.scoreRow(row);
            if (!(score > bestScore)) continue;
            bestScore = score;
        }
        return (int)Math.floor(100.0 * bestScore / (double)(numbColumns - 2));
    }

    public static int[] constructRow(int[] row_order, int[][] swag_array, int period, int numb_columns) {
        int[] row = new int[numb_columns];
        int index = 0;
        for (int i = 0; i < numb_columns; ++i) {
            int c;
            row[i] = c = swag_array[row_order[index]][i];
            if (++index != period) continue;
            index = 0;
        }
        return row;
    }

    public static int scoreRow(int[] row) {
        int score = 0;
        for (int i = 0; i < row.length - 2; ++i) {
            score += bstd[row[i] + 26 * row[i + 1] + 676 * row[i + 2]];
        }
        return score;
    }

    public static Object[] next_per(int[] str, int le) {
        if (le < 2) {
            return new Object[]{0, str};
        }
        int last = le - 2;
        while (str[last] >= str[last + 1]) {
            if (last == 0) {
                return new Object[]{0, str};
            }
            --last;
        }
        int fst = le - 1;
        while (str[fst] <= str[last]) {
            --fst;
        }
        int c = str[last];
        str[last] = str[fst];
        str[fst] = c;
        if (str[last + 1] != str[le - 1]) {
            int i = 1;
            while (last + i < le - i) {
                c = str[last + i];
                str[last + i] = str[le - i];
                str[le - i] = c;
                ++i;
            }
        }
        return new Object[]{1, str};
    }

    public static double calculateMPIC(String text) {
        if (StatCalculator.containsDigit(text) || StatCalculator.containsHash(text)) {
            return 0.0;
        }
        double mx = 0.0;
        int max_period = 15;
        int[][] ct = new int[max_period + 1][26];
        for (int i = 0; i <= max_period; ++i) {
            Arrays.fill(ct[i], 0);
        }
        for (int period = 1; period <= max_period; ++period) {
            for (int prog_index = 1; prog_index < 26; ++prog_index) {
                for (int i = 0; i < period; ++i) {
                    Arrays.fill(ct[i], 0);
                }
                int index = 0;
                int prog_incr = 0;
                for (int i = 0; i < text.length(); ++i) {
                    int c = (26 + text.charAt(i) - 65 - prog_incr) % 26;
                    int[] nArray = ct[index];
                    int n = c;
                    nArray[n] = nArray[n] + 1;
                    if (++index != period) continue;
                    index = 0;
                    prog_incr = (prog_incr + prog_index) % 26;
                }
                double z = 0.0;
                for (int i = 0; i < period; ++i) {
                    double x = 0.0;
                    double y = 0.0;
                    for (int j = 0; j < 26; ++j) {
                        x += (double)(ct[i][j] * (ct[i][j] - 1));
                        y += (double)ct[i][j];
                    }
                    if (!(y > 1.0)) continue;
                    z += x / (y * (y - 1.0));
                }
                if (!((z /= (double)period) > mx)) continue;
                mx = z;
            }
        }
        return Math.floor(1000.0 * mx);
    }

    public static boolean calculateSeriatedPlayfair(String text, int period) {
        for (int i = 0; i < text.length(); i += period * 2) {
            int min = Math.min(period, (text.length() - i) / 2);
            for (int j = 0; j < min; ++j) {
                char b;
                char a = text.charAt(i + j);
                if (a != (b = text.charAt(i + j + min))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean calculateSeriatedPlayfair(String text, int minPeriod, int maxPeriod) {
        if (text.length() % 2 == 1) {
            return false;
        }
        for (int period = 2; period <= 40; ++period) {
            if (!StatCalculator.calculateSeriatedPlayfair(text, period)) continue;
            return true;
        }
        return false;
    }
}

