/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers.solitaire;

import com.alexbarter.lib.util.ArrayUtil;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import tools.cipher.base.key.KeyIterator;
import tools.cipher.ciphers.solitaire.DeckParse;
import tools.cipher.ciphers.solitaire.Solitaire;
import tools.cipher.lib.ListUtil;
import tools.cipher.lib.Timer;
import tools.cipher.lib.characters.StringUtils;
import tools.cipher.lib.fitness.NGramData;
import tools.cipher.lib.fitness.TextFitness;
import tools.cipher.lib.language.Languages;
import tools.cipher.lib.result.DynamicResultList;
import tools.cipher.lib.result.Result;
import tools.cipher.lib.result.Solution;

public class SolitaireSolver {
    public static final int LARGEST_UNKNOWNS_ITERABLE = 7;
    public static SolitaireSolutionEver BEST_SOLUTION = new SolitaireSolutionEver();

    public static DynamicResultList<SolutionWithDeck> swiftAttack(CharSequence cipherText, int n, int offset, DeckParse deck, int noSol, PrintStream out) {
        return SolitaireSolver.swiftAttack(cipherText, new char[0], n, offset, deck, noSol, out, 0);
    }

    public static DynamicResultList<SolutionWithDeck> swiftAttack(CharSequence cipherText, char[] prefix, int n, int offset, DeckParse deck, int solutionsCarryFoward, PrintStream out, int time) {
        SoiltaireSwiftAttack attack = new SoiltaireSwiftAttack(cipherText.subSequence(offset + 0, offset + n), prefix, solutionsCarryFoward, out, time);
        Timer timer = new Timer();
        Solitaire.specialAttack(attack, deck.order, deck.unknownCards);
        out.print("\n");
        attack.solutions.sort();
        Iterator ite = attack.solutions.iterator();
        for (int i = 0; ite.hasNext() && i < 10; ++i) {
            SolutionWithDeck s = (SolutionWithDeck)((Object)ite.next());
            out.println(s.toString());
        }
        out.print("\n");
        out.println(String.format(StringUtils.repeat((CharSequence)"   ", (int)time) + "Completed %s round order in %dms, examining %d out of %d", (new String[]{"first", "second", "third", "fouth", "fifth", "sixth", "seventh", "eight", "nineth", "tenth"})[time], timer.getTimeRunning(TimeUnit.MICROSECONDS), attack.solutions.size(), attack.total));
        return attack.solutions;
    }

    public static void startCompleteAttack(CharSequence cipherText, int n, int solutionsCarryFoward, DeckParse startingDeck, PrintStream out, int time) {
        SolitaireSolver.completeAttack(BEST_SOLUTION, cipherText, new char[0], n, solutionsCarryFoward, 0, startingDeck, out, time);
    }

    public static void completeAttack(SolitaireSolutionEver bestSolutionEver, CharSequence cipherText, char[] prefix, int n, int solutionsCarryFoward, int offset, DeckParse startingDeck, PrintStream out, int time) {
        out.print(String.format("%sUnknowns: %d: ", StringUtils.repeat((CharSequence)"   ", (int)time), startingDeck.countUnknowns()));
        DynamicResultList<SolutionWithDeck> solutions = SolitaireSolver.swiftAttack(cipherText, prefix, n, offset, startingDeck, solutionsCarryFoward, out, time);
        SolitaireSolution task = new SolitaireSolution(bestSolutionEver, cipherText.subSequence(offset + n, cipherText.length()).toString().toCharArray(), offset + n, out, time);
        for (SolutionWithDeck solution : solutions) {
            DeckParse deck = new DeckParse(solution.deck);
            task.incompleteOrder = deck.order;
            task.emptyIndex = deck.emptyIndex;
            if (deck.countUnknowns() > 7) {
                SolitaireSolver.completeAttack(bestSolutionEver, cipherText, solution.getRaw(), n, solutionsCarryFoward, offset + n, deck, out, time + 1);
                continue;
            }
            for (int k = 0; k < n + offset; ++k) {
                task.text[k] = solution.getRaw()[k];
            }
            KeyIterator.permuteObject(task::onIteration, (Object[])deck.unknownCards);
        }
    }

    private static class SoiltaireSwiftAttack
    implements Solitaire.SolitaireAttack {
        public Solution bestSolution = Solution.WORST_SOLUTION;
        public DynamicResultList<SolutionWithDeck> solutions;
        public int total;
        public char[] intText;
        public char[] prefix;
        public double minFitness;
        public PrintStream out;
        public int time;

        private SoiltaireSwiftAttack(CharSequence cipherText, char[] prefix, int solutionsCarryFoward, PrintStream out, int time) {
            int i;
            this.solutions = new DynamicResultList(time == 0 ? solutionsCarryFoward : 512);
            this.intText = new char[cipherText.length() + prefix.length];
            this.prefix = prefix;
            for (i = 0; i < prefix.length; ++i) {
                this.intText[i] = (char)(prefix[i] - 65);
            }
            while (i < this.intText.length) {
                this.intText[i] = (char)(cipherText.charAt(i - prefix.length) - 65);
                ++i;
            }
            this.minFitness = TextFitness.getEstimatedFitness((int)this.intText.length, (NGramData)Languages.ENGLISH.getTrigramData()) * 1.5;
            this.out = out;
            this.time = time;
        }

        @Override
        public void tryKeyStream(int[] keyStream, Integer[] lastOrder) {
            char[] chars = Solitaire.decodeWithKeyStream(this.intText, this.prefix.length, keyStream);
            SolutionWithDeck last = new SolutionWithDeck(chars, Languages.ENGLISH.getTrigramData(), lastOrder);
            if (this.solutions.add((Result)last)) {
                last.bakeDeck();
            }
            if (this.bestSolution.score < last.score) {
                this.bestSolution = last;
                this.out.print(this.bestSolution.getText() + " ");
            }
            ++this.total;
        }

        @Override
        public int getSubBranches() {
            return this.intText.length - this.prefix.length;
        }
    }

    public static class SolitaireSolution {
        public SolitaireSolutionEver bestSolutionEver;
        public char[] text;
        public int startingLength;
        public Integer[] incompleteOrder;
        public Integer[] emptyIndex;
        public Solution lastSolution;
        public PrintStream out;
        public int time;

        public SolitaireSolution(SolitaireSolutionEver bestSolutionEver, char[] text, int startingLength, PrintStream out, int time) {
            this.bestSolutionEver = bestSolutionEver;
            this.text = ArrayUtil.concat((char[])new char[startingLength], (char[])text);
            this.startingLength = startingLength;
            this.out = out;
            this.time = time;
        }

        public boolean onIteration(Integer[] order) {
            for (int i = 0; i < this.emptyIndex.length; ++i) {
                this.incompleteOrder[this.emptyIndex[i].intValue()] = order[i];
            }
            this.lastSolution = new Solution(Solitaire.decode(this.text, this.startingLength, this.incompleteOrder), Languages.ENGLISH.getTrigramData());
            if (this.lastSolution.score >= this.bestSolutionEver.bestSolution.score) {
                this.bestSolutionEver.bestSolution = this.lastSolution;
                this.bestSolutionEver.bestSolution.setKeyString(ListUtil.toString((Integer[])this.incompleteOrder, (int)1));
                this.out.println(String.format(StringUtils.repeat((CharSequence)"   ", (int)this.time) + "%s", this.bestSolutionEver));
            }
            return true;
        }
    }

    public static class SolutionWithDeck
    extends Solution {
        private Integer[] deck;

        public SolutionWithDeck(char[] text, NGramData nGramData, Integer[] deck) {
            super(text, nGramData);
            this.deck = deck;
            this.setKeyString(ListUtil.toCardString((Integer[])this.deck, (int)1));
        }

        public void bakeDeck() {
            this.deck = (Integer[])ArrayUtil.copy((Object[])this.deck);
        }
    }

    public static class SolitaireSolutionEver {
        public Solution bestSolution = Solution.WORST_SOLUTION;

        public String toString() {
            return this.bestSolution.toString();
        }
    }
}

