/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.ciphers.BiKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.FullStringKeyType;
import tools.cipher.base.key.types.SquareMatrixKeyType;
import tools.cipher.ciphers.KeywordCipher;
import tools.cipher.lib.characters.CharArrayWrapper;
import tools.cipher.lib.matrix.Matrix;

public class HillSubstitutionCipher
extends BiKeyCipher<Matrix, String, SquareMatrixKeyType.Builder, FullStringKeyType.Builder> {
    private KeywordCipher keywordCipher = new KeywordCipher();

    public HillSubstitutionCipher() {
        super((IKeyType.IKeyBuilder)SquareMatrixKeyType.builder(), (IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<Matrix, String> key) {
        int blockSize = ((Matrix)key.getFirstKey()).size();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Matrix, String> key) {
        char[] cipherText = new char[plainText.length()];
        int size = ((Matrix)key.getFirstKey()).size();
        plainText = this.keywordCipher.encode(plainText, (String)key.getSecondKey());
        for (int i = 0; i < plainText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = plainText.charAt(i + j) - 65;
            }
            Matrix plainMatrix = new Matrix(let, size, 1);
            Matrix cipherMatrix = ((Matrix)key.getFirstKey()).multiply(plainMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                cipherText[i + j] = (char)(cipherMatrix.data[j] + 65);
            }
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Matrix, String> key) {
        return this.decodeUsingInverse(cipherText, plainText, ((Matrix)key.getFirstKey()).inverseMod(26), (String)key.getSecondKey());
    }

    public char[] decodeUsingInverse(CharSequence cipherText, char[] plainText, Matrix inverseKey, String secondKey) {
        int size = inverseKey.size();
        for (int i = 0; i < cipherText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = cipherText.charAt(i + j) - 65;
            }
            Matrix cipherMatrix = new Matrix(let, size, 1);
            Matrix plainMatrix = inverseKey.multiply(cipherMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                plainText[i + j] = (char)(plainMatrix.data[j] + 65);
            }
        }
        plainText = this.keywordCipher.decodeEfficiently((CharSequence)new CharArrayWrapper(plainText), plainText, secondKey);
        return plainText;
    }
}

