/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.util;

public abstract class VigenereType {
    public static final VigenereType NONE = new None();
    public static final VigenereType BEAUFORT = new Beaufort();
    public static final VigenereType PORTA = new Porta();
    public static final VigenereType PORTA_VARIANT = new PortaVariant();
    public static final VigenereType VARIANT = new Variant();
    public static final VigenereType VIGENERE = new Vigenere();
    public static final VigenereType[] SLIDEFAIR_LIST = new VigenereType[]{BEAUFORT, VARIANT, VIGENERE};
    public static final VigenereType[] NORMAL_LIST = new VigenereType[]{BEAUFORT, PORTA, PORTA_VARIANT, VARIANT, VIGENERE};

    private VigenereType() {
    }

    public abstract char encode(char var1, char var2);

    public abstract char decode(char var1, char var2);

    private static class Vigenere
    extends VigenereType {
        private Vigenere() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            return (char)((keyCharId + textCharId) % 26 + 65);
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return (char)((-keyCharId + textCharId + 26) % 26 + 65);
        }
    }

    private static class Variant
    extends VigenereType {
        private Variant() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            return (char)((-keyCharId + textCharId + 26) % 26 + 65);
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return (char)((keyCharId + textCharId) % 26 + 65);
        }
    }

    private static class PortaVariant
    extends VigenereType {
        private PortaVariant() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            char key = (char)((keyCharId - 65) / 2);
            char newCharId = textCharId;
            if (newCharId < 'N') {
                newCharId = (char)(newCharId + 13);
                if ((newCharId = (char)(newCharId - key)) < 'N') {
                    newCharId = (char)(newCharId + 13);
                }
            } else {
                newCharId = (char)(newCharId - 13);
                if ((newCharId = (char)(newCharId + key)) > 'M') {
                    newCharId = (char)(newCharId - 13);
                }
            }
            return newCharId;
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return this.encode(textCharId, keyCharId);
        }
    }

    private static class Porta
    extends VigenereType {
        private Porta() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            char key = (char)((keyCharId - 65) / 2);
            char newCharId = textCharId;
            if (newCharId < 'N') {
                if ((newCharId = (char)(newCharId + key)) < 'N') {
                    newCharId = (char)(newCharId + 13);
                }
            } else if ((newCharId = (char)(newCharId - key)) > 'M') {
                newCharId = (char)(newCharId - 13);
            }
            return newCharId;
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return this.encode(textCharId, keyCharId);
        }
    }

    private static class Beaufort
    extends VigenereType {
        private Beaufort() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            return (char)((keyCharId - textCharId + 26) % 26 + 65);
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return this.encode(textCharId, keyCharId);
        }
    }

    private static class None
    extends VigenereType {
        private None() {
        }

        @Override
        public char encode(char textCharId, char keyCharId) {
            return textCharId;
        }

        @Override
        public char decode(char textCharId, char keyCharId) {
            return textCharId;
        }
    }
}

