/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.FullStringKeyType;
import tools.cipher.lib.characters.CharacterArrayWrapper;

public class KeywordCipher
extends UniKeyCipher<String, FullStringKeyType.Builder> {
    public KeywordCipher() {
        this("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public KeywordCipher(CharSequence alphabet) {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet(alphabet));
    }

    public CharSequence encode(CharSequence plainText, String key) {
        Character[] cipherText = new Character[plainText.length()];
        for (int i = 0; i < plainText.length(); ++i) {
            char ch = plainText.charAt(i);
            if (ch < 'A' || ch > 'Z') continue;
            cipherText[i] = Character.valueOf(key.charAt(ch - 65));
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        for (int i = 0; i < cipherText.length(); ++i) {
            plainText[i] = (char)(key.indexOf(cipherText.charAt(i)) + 65);
        }
        return plainText;
    }
}

