/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import com.alexbarter.lib.util.ArrayUtil;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Nullable;
import tools.cipher.base.ciphers.QuinKey;
import tools.cipher.base.ciphers.QuinKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.IntegerKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.base.key.types.PlugboardKeyType;
import tools.cipher.ciphers.enigma.EnigmaMachine;
import tools.cipher.lib.CipherUtils;
import tools.cipher.lib.characters.CharArrayWrapper;
import tools.cipher.lib.characters.CharSequenceUtils;

public class EnigmaPlugboardCipher
extends QuinKeyCipher<Integer[], Integer[], Integer[], Integer, Integer[], OrderedIntegerKeyType.Builder, OrderedIntegerKeyType.Builder, OrderedIntegerKeyType.Builder, IntegerKeyType.Builder, PlugboardKeyType.Builder> {
    private EnigmaMachine machine;

    public EnigmaPlugboardCipher(EnigmaMachine machine) {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(26).setRepeats().setDisplay(CipherUtils::displayAsLetters), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(26).setRepeats().setDisplay(CipherUtils::displayAsLetters), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(machine.getRotorCount()), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(0, machine.getReflectorCount() - 1), (IKeyType.IKeyBuilder)PlugboardKeyType.builder());
        this.machine = machine;
    }

    @Deprecated
    public EnigmaPlugboardCipher setMachine(EnigmaMachine machine) {
        this.machine = machine;
        return this;
    }

    public CharSequence encode(CharSequence plainText, QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]> key) {
        return new CharArrayWrapper(this.decodeEfficiently(plainText, key));
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]> key) {
        Integer[] indicator = (Integer[])ArrayUtil.copy((Object[])((Object[])key.getFirstKey()));
        Integer[] ring = (Integer[])ArrayUtil.copy((Object[])((Object[])key.getSecondKey()));
        int thinRotor = 0;
        for (int i = 0; i < cipherText.length(); ++i) {
            int r;
            this.nextRotorPosition((Integer[])key.getThirdKey(), indicator);
            int ch = cipherText.charAt(i) - 65;
            if (key.getFifthKey() != null) {
                ch = this.nextCharacter(ch, (Integer[])key.getFifthKey());
            }
            for (r = 2; r >= 0; --r) {
                ch = this.nextCharacter(ch, this.machine.rotors[((Integer[])key.getThirdKey())[r]], indicator[r] - ring[r]);
            }
            if (this.machine.hasThinRotor()) {
                ch = this.nextCharacter(ch, this.machine.thinRotor[thinRotor]);
            }
            ch = this.nextCharacter(ch, this.machine.reflector[(Integer)key.getFourthKey()]);
            if (this.machine.hasThinRotor()) {
                ch = this.nextCharacter(ch, this.machine.thinRotorInverse[thinRotor]);
            }
            for (r = 0; r < 3; ++r) {
                ch = this.nextCharacter(ch, this.machine.rotorsInverse[((Integer[])key.getThirdKey())[r]], indicator[r] - ring[r]);
            }
            if (key.getFifthKey() != null) {
                ch = this.nextCharacter(ch, (Integer[])key.getFifthKey());
            }
            plainText[i] = (char)(ch + 65);
        }
        return plainText;
    }

    public void nextRotorPosition(Integer[] rotors, Integer[] indicator) {
        if (this.machine.getStepping()) {
            Integer[] integerArray;
            Object[] middleNotches = this.machine.notches[rotors[1]];
            Object[] endNotches = this.machine.notches[rotors[2]];
            if (ArrayUtil.contains((Object[])middleNotches, (Object)indicator[1])) {
                integerArray = indicator;
                Integer.valueOf(integerArray[0] + 1);
                integerArray = indicator;
                Integer.valueOf(integerArray[1] + 1);
                if (indicator[0] > 25) {
                    indicator[0] = 0;
                }
                if (indicator[1] > 25) {
                    indicator[1] = 0;
                }
            }
            if (ArrayUtil.contains((Object[])endNotches, (Object)indicator[2])) {
                integerArray = indicator;
                Integer.valueOf(integerArray[1] + 1);
                if (indicator[1] > 25) {
                    indicator[1] = 0;
                }
            }
            integerArray = indicator;
            Integer.valueOf(integerArray[2] + 1);
            if (indicator[2] > 25) {
                indicator[2] = 0;
            }
        } else {
            Object[] endNotches = this.machine.notches[rotors[2]];
            if (ArrayUtil.contains((Object[])endNotches, (Object)indicator[2])) {
                Object[] middleNotches = this.machine.notches[rotors[1]];
                if (ArrayUtil.contains((Object[])middleNotches, (Object)indicator[1])) {
                    indicator[0] = (indicator[0] + 1) % 26;
                }
                indicator[1] = (indicator[1] + 1) % 26;
            }
            indicator[2] = (indicator[2] + 1) % 26;
        }
    }

    public int nextCharacter(int ch, Integer[] key) {
        return key[ch];
    }

    public int nextCharacter(int ch, Integer[] key, int offset) {
        if (offset > 0) {
            if ((ch += offset) > 25) {
                ch -= 26;
            }
            ch = this.nextCharacter(ch, key);
            if ((ch -= offset) < 0) {
                ch += 26;
            }
        } else if (offset < 0) {
            if ((ch += offset) < 0) {
                ch += 26;
            }
            ch = this.nextCharacter(ch, key);
            if ((ch -= offset) > 25) {
                ch -= 26;
            }
        } else {
            ch = this.nextCharacter(ch, key);
        }
        return ch;
    }

    public QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]> parseKey(String input) throws ParseException {
        String[] parts = input.split(" ");
        if (parts.length != 5) {
            throw new ParseException(input, 0);
        }
        return QuinKey.of((Object)EnigmaPlugboardCipher.parseLetterToInteger(this.machine, parts[0]), (Object)EnigmaPlugboardCipher.parseLetterToInteger(this.machine, parts[1]), (Object)EnigmaPlugboardCipher.parseCogNumber(this.machine, parts[2]), (Object)EnigmaPlugboardCipher.parseReflector(this.machine, parts[3]), (Object)this.getFifthKeyType().parse(parts[4]));
    }

    public static Integer[] parseLetterToInteger(EnigmaMachine machine, String s) throws ParseException {
        if (s.length() != 3) {
            throw new ParseException("Ring/Indicator settings must be 3 letters", 0);
        }
        if (!CharSequenceUtils.isCharSubset((CharSequence)(s = s.toUpperCase(Locale.ROOT)), (CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ")) {
            throw new ParseException("Ring/Indicator setting has invalid letters", 0);
        }
        Integer[] key = new Integer[]{s.charAt(0) - 65, s.charAt(1) - 65, s.charAt(2) - 65};
        return key;
    }

    public static Integer[] parseCogNumber(EnigmaMachine machine, String s) throws ParseException {
        Object[] MAPPING = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        String[] elements = s.split(",");
        Object[] key = new Integer[3];
        int offset = 0;
        for (int i = 0; i < elements.length; ++i) {
            int cogIdx = ArrayUtil.indexOf((Object[])MAPPING, (Object)elements[i]);
            if (cogIdx == -1 || cogIdx >= machine.getRotorCount()) {
                throw new ParseException("Invalid cog roman numeral given", offset);
            }
            if (ArrayUtil.contains((Object[])key, (int)0, (int)i, (Object)cogIdx)) {
                throw new ParseException("Duplicate cog used " + elements[i], offset);
            }
            key[i] = cogIdx;
            offset += elements[i].length() + 1;
        }
        return key;
    }

    public static Integer parseReflector(EnigmaMachine machine, String s) throws ParseException {
        int reflectorIdx = ArrayUtil.indexOf((Object[])machine.reflectorNames, (Object)s);
        if (reflectorIdx == -1) {
            throw new ParseException("Invalid reflector", 0);
        }
        return reflectorIdx;
    }
}

