/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.IRangedKeyType;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.IKeySearchAttack;

public class PeriodicKeyAttack<C extends UniKeyCipher<String, ? extends IRangedKeyType.IRangedKeyBuilder<String>>>
extends CipherAttack<String, C>
implements IKeySearchAttack<String> {
    public int[] periodRange;
    private int charStep = 1;

    public PeriodicKeyAttack(C cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.BRUTE_FORCE});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)15, (int)2, (int)100, (int)1, (range, cipher2) -> {
            this.periodRange = range;
            cipher2.setDomain(builder -> builder.setRange(range));
        })});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        IDecryptionTracker tracker = this.createTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int period = this.periodRange[0]; period <= this.periodRange[1]; ++period) {
                    this.tryKeySearch(tracker, period);
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return periodicPart;
    }

    public int getCharStep() {
        return this.charStep;
    }

    public PeriodicKeyAttack<C> setCharStep(int charStep) {
        this.charStep = charStep;
        return this;
    }
}

