/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.ISimulatedAnnealingAttack;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.ciphers.PlayfairCipher;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import java.util.ArrayList;
import java.util.HashSet;

public class PolybusSquareAttack
extends CipherAttack<String, PlayfairCipher>
implements ISimulatedAnnealingAttack<String> {
    public PolybusSquareAttack() {
        super(null, "Polybus Square");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING});
    }

    public IDecryptionTracker trySimulatedAnnealing(IDecryptionTracker tracker, int iterations) {
        ArrayList<String> split = new ArrayList<String>();
        for (int i = 0; i < tracker.getLength(); i += 2) {
            split.add(tracker.getCipherText().charAt(i) + "" + tracker.getCipherText().charAt(i + 1));
        }
        this.output(tracker, ((Object)split).toString(), new Object[0]);
        char[] tempText = new char[split.size()];
        HashSet nonDupList = new HashSet(split);
        int t = 0;
        for (String nonDup : nonDupList) {
            for (int i = 0; i < split.size(); ++i) {
                if (!((String)split.get(i)).equals(nonDup)) continue;
                tempText[i] = "ABCDEFGHIKLMNOPQRSTUVWXYZ".charAt(t);
            }
            ++t;
        }
        CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIKLMNOPQRSTUVWXYZ"), "Polybus Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(5).mute();
        IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(tempText), DecryptionMethod.SIMULATED_ANNEALING, tracker.getApp());
        this.updateIfBetterThanBest(tracker, keywordTracker.getBestSolution());
        return tracker;
    }
}

