/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyGeneration;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.settings.SettingsCache;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.result.Solution;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.StringJoiner;

public class GeneralPeriodAttack
extends CipherAttack {
    private int period;

    public GeneralPeriodAttack() {
        super(null, "General Period Subsitution");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntSpinner((String)"period", (int)5, (int)1, (int)100, (int)1, (value, cipher) -> {
            this.period = value;
        })});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            default: 
        }
        return super.attemptAttack(text, method, app);
    }

    public IDecryptionTracker trySimulatedAnnealing(IDecryptionTracker tracker, int iterations) {
        int p;
        int rowsMin = tracker.getLength() / this.period;
        int colLeft = tracker.getLength() % this.period;
        int[] height = new int[this.period];
        char[][] keysIndex = new char[this.period][26];
        List letter = tracker.getLanguage().getLetterLargestFirst();
        for (int p2 = 0; p2 < this.period; ++p2) {
            height[p2] = (rowsMin + (colLeft > p2 ? 1 : 0)) * this.period;
            keysIndex[p2] = KeyGeneration.createLongKey26().toCharArray();
        }
        char[] editText = tracker.getNewHolder();
        for (p = 0; p < this.period; ++p) {
            for (int i = p; i < height[p]; i += this.period) {
                char ch = tracker.getCipherText().charAt(i);
                editText[i] = (char)(ArrayUtil.indexOf((char[])keysIndex[p], (char)ch) + 65);
            }
        }
        tracker.getProgress().addMax(BigInteger.valueOf((long)Math.floor((Double)((List)SettingsCache.simulatedAnnealing.get()).get(0) / (Double)((List)SettingsCache.simulatedAnnealing.get()).get(1)) + 1L).multiply(BigInteger.valueOf(((Double)((List)SettingsCache.simulatedAnnealing.get()).get(2)).intValue())));
        System.out.println(new String(editText));
        for (p = 0; p < this.period; ++p) {
            System.out.println(new String(keysIndex[p]));
        }
        Solution bestMaximaSolution = new Solution(editText, tracker.getLanguage());
        tracker.addSolution(bestMaximaSolution);
        StringJoiner str2 = new StringJoiner(", ");
        for (int j = 0; j < this.period; ++j) {
            str2.add((CharSequence)new CharArrayWrapper(keysIndex[j]));
        }
        bestMaximaSolution.setKeyString(str2.toString());
        this.updateIfBetterThanBest(tracker, bestMaximaSolution);
        boolean ite = false;
        block5: while (true) {
            this.startIteration(tracker);
            double TEMP = (Double)((List)SettingsCache.simulatedAnnealing.get()).get(0);
            do {
                TEMP = Math.max(0.0, TEMP - (Double)((List)SettingsCache.simulatedAnnealing.get()).get(1));
                int count = 0;
                while ((double)count < (Double)((List)SettingsCache.simulatedAnnealing.get()).get(2)) {
                    if (tracker.shouldStop()) break block5;
                    for (int p3 = 0; p3 < this.period; ++p3) {
                        int i;
                        char ch1 = RandomUtil.pickRandomChar((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                        char ch2 = RandomUtil.pickRandomChar((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                        for (i = p3; i < height[p3]; i += this.period) {
                            if (editText[i] == ch1) {
                                editText[i] = ch2;
                                continue;
                            }
                            if (editText[i] != ch2) continue;
                            editText[i] = ch1;
                        }
                        tracker.setLastSolution(new Solution(editText, tracker.getLanguage()));
                        tracker.addSolution(tracker.getLastSolution());
                        if (this.shouldAcceptSolution(TEMP, tracker.getLastSolution(), bestMaximaSolution)) {
                            bestMaximaSolution = tracker.getLastSolution();
                            char temp = keysIndex[p3][ch1 - 65];
                            keysIndex[p3][ch1 - 65] = keysIndex[p3][ch2 - 65];
                            keysIndex[p3][ch2 - 65] = temp;
                            StringJoiner str = new StringJoiner(", ");
                            for (int j = 0; j < this.period; ++j) {
                                str.add((CharSequence)new CharArrayWrapper(keysIndex[j]));
                            }
                            bestMaximaSolution.setKeyString(str.toString());
                            this.updateIfBetterThanBest(tracker, bestMaximaSolution);
                            continue;
                        }
                        for (i = p3; i < height[p3]; i += this.period) {
                            if (editText[i] == ch1) {
                                editText[i] = ch2;
                                continue;
                            }
                            if (editText[i] != ch2) continue;
                            editText[i] = ch1;
                        }
                    }
                    this.onPostIteration(tracker);
                    ++count;
                }
            } while (TEMP > 0.0);
            tracker.getProgress().finish();
            if (this.endIteration(tracker, tracker.getBestSolution())) break;
            this.output(tracker, "============================ Temperture Reset", new Object[0]);
        }
        return tracker;
    }
}

