/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import java.util.Arrays;
import javax.annotation.Nullable;

public class PortaxCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    public PortaxCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 15);
    }

    public CharSequence normaliseText(CharSequence plainText, String key) {
        if (plainText.length() % 2 == 1) {
            StringBuilder builder = new StringBuilder(plainText.length() + 1);
            builder.append(plainText);
            builder.append('X');
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, String key) {
        return this.decode(plainText, key);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int i;
        int period = key.length();
        Object[] slidingKey = new String[period];
        Arrays.fill(slidingKey, "");
        for (i = 0; i < key.length(); ++i) {
            char slidingChar = key.charAt(i);
            int slide = (slidingChar - 65) / 2;
            for (int s = 0; s < 13; ++s) {
                int n = i;
                slidingKey[n] = (String)slidingKey[n] + (char)((13 + s - slide) % 13 + 65);
            }
        }
        for (i = 0; i < cipherText.length(); i += period * 2) {
            int actingPeriod = Math.min((cipherText.length() - i) / 2, period);
            for (int j = 0; j < actingPeriod; ++j) {
                char d;
                char c;
                int aIndex;
                char a = cipherText.charAt(i + j);
                char b = cipherText.charAt(i + j + actingPeriod);
                int row = (b - 65) % 2;
                int column = (b - 65) / 2;
                if (a <= 'M') {
                    aIndex = ((String)slidingKey[j]).indexOf(a);
                    if (aIndex == column) {
                        c = (char)(column + 78);
                        d = (char)(aIndex * 2 + (row + 1) % 2 + 65);
                    } else {
                        c = ((String)slidingKey[j]).charAt(column);
                        d = (char)(aIndex * 2 + row + 65);
                    }
                } else {
                    aIndex = a - 78;
                    if (aIndex == column) {
                        c = ((String)slidingKey[j]).charAt(column);
                        d = (char)(aIndex * 2 + (row + 1) % 2 + 65);
                    } else {
                        c = (char)(column + 78);
                        d = (char)(aIndex * 2 + row + 65);
                    }
                }
                plainText[i + j] = c;
                plainText[i + j + actingPeriod] = d;
            }
        }
        return plainText;
    }
}

