/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerGenKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import java.util.Map;
import javax.annotation.Nullable;

public class BifidCipher
extends BiKeyCipher<String, Integer, SquareStringKeyType.Builder, IntegerGenKeyType.Builder> {
    public BifidCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)IntegerGenKeyType.builder().setRange(0, 5000).addFilter(i -> i != 1));
    }

    public IntegerGenKeyType.Builder limitDomainForSecondKey(IntegerGenKeyType.Builder secondKey) {
        return secondKey.setRange(0, 15);
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<String, Integer> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, Integer> key) {
        return BifidCipher.encodeGeneral(plainText, (String)key.getFirstKey(), (String)key.getFirstKey(), (Integer)key.getSecondKey());
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, Integer> key) {
        return BifidCipher.decodeGeneral(cipherText, plainText, (String)key.getFirstKey(), (String)key.getFirstKey(), (Integer)key.getSecondKey());
    }

    protected static CharSequence encodeGeneral(CharSequence plainText, String keysquare1, String keysquare2, int period) {
        if (period == 0) {
            period = plainText.length();
        }
        int[] digits = new int[plainText.length() * 2];
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            int charIndex = keysquare1.indexOf(c);
            int charRow = (int)Math.floor(charIndex / 5);
            int charCol = charIndex % 5;
            int blockNo = (int)Math.floor(i / period);
            int blockSize = Math.min(period, plainText.length() - blockNo * period);
            int blockCol = (i - blockNo * period) % blockSize;
            digits[blockNo * period * 2 + blockCol] = charRow;
            digits[blockNo * period * 2 + blockSize + blockCol] = charCol;
        }
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i = 0; i < digits.length; i += 2) {
            int row = digits[i];
            int column = digits[i + 1];
            cipherText.append(keysquare2.charAt(row * 5 + column));
        }
        return cipherText;
    }

    protected static char[] decodeGeneral(CharSequence cipherText, @Nullable char[] plainText, String keysquare1, String keysquare2, int period) {
        if (period == 0) {
            period = cipherText.length();
        }
        Map keyIndex2 = CipherUtils.createCharacterIndexMapping((CharSequence)keysquare2);
        int[] numberText = new int[cipherText.length() * 2];
        for (int i = 0; i < cipherText.length(); ++i) {
            char a = cipherText.charAt(i);
            int index = (Integer)keyIndex2.get(Character.valueOf(a));
            int row = index / 5;
            int column = index % 5;
            int lowestCol = i / period * period;
            int actualPeriod = Math.min(period, cipherText.length() - lowestCol);
            int blockSize = 2 * actualPeriod;
            int relCol = i - lowestCol;
            int blockBase = lowestCol * 2;
            int posMultipler = relCol * 4;
            if (relCol * 2 < actualPeriod) {
                numberText[blockBase + posMultipler] = row;
            } else {
                numberText[blockBase + posMultipler - blockSize + 1] = row;
            }
            if (relCol * 2 + 1 < actualPeriod) {
                numberText[blockBase + posMultipler + 2] = column;
                continue;
            }
            numberText[blockBase + posMultipler - blockSize + 3] = column;
        }
        int index = 0;
        for (int i = 0; i < numberText.length; i += 2) {
            int a = numberText[i];
            int b = numberText[i + 1];
            plainText[index++] = keysquare1.charAt(a * 5 + b);
        }
        return plainText;
    }
}

