/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.settings.ComponentParse;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.HillCipher;
import com.alexbarter.ciphertool.lib.characters.CharacterCount;
import com.alexbarter.ciphertool.lib.characters.StringUtils;
import com.alexbarter.ciphertool.lib.file.FileReader;
import com.alexbarter.ciphertool.lib.fitness.ChiSquared;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.ciphertool.lib.math.SimultaneousEquations;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.ciphertool.lib.matrix.MatrixNoInverse;
import com.alexbarter.ciphertool.lib.matrix.MatrixNotSquareException;
import com.alexbarter.ciphertool.lib.result.DynamicResultList;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.result.ResultPositive;
import com.alexbarter.ciphertool.lib.result.Solution;
import com.alexbarter.ciphertool.lib.swing.JSpinnerUtil;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class HillAttack
extends CipherAttack<Matrix, HillCipher> {
    public JSpinner gramSearchRange;
    public JComboBox<String> trigramSets;
    public final String[][] BI_GRAM = new String[][]{{"TH", "HE"}};
    public final String[][] TRI_GRAM = new String[][]{{"ENT", "LES", "ION"}, {"THE", "ING", "ENT"}, {"THE", "ING", "ION"}, {"THE", "ENT", "ION"}, {"ING", "ENT", "HER"}, {"ING", "ENT", "FOR"}, {"ENT", "ION", "HER"}, {"ING", "ENT", "THA"}, {"ING", "ENT", "NTH"}};
    public final String[] TRI_GRAM_DISPLAY = new String[]{"THE AND ING", "THE ING ENT", "THE ING ION", "THE ENT ION", "ING ENT HER", "ING ENT FOR", "ENT ION HER", "ING ENT THA", "ING ENT NTH"};
    private int[] sizeRange = new int[]{2, 4};

    public HillAttack() {
        super((ICipher)new HillCipher(), "Hill");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.CALCULATED, DecryptionMethod.PERIODIC_KEY, DecryptionMethod.SIMULATED_ANNEALING});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"size_range", (int)2, (int)4, (int)2, (int)100, (int)1, (values, cipher) -> {
            this.sizeRange = values;
        })});
        this.gramSearchRange = JSpinnerUtil.createSpinner((int)20, (int)3, (int)100, (int)1);
        this.trigramSets = new JComboBox<String>(this.TRI_GRAM_DISPLAY);
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        super.createSettingsUI(dialog, panel);
        panel.add(this.gramSearchRange);
        panel.add(this.trigramSets);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        HillTracker tracker = new HillTracker(text, app);
        int gramSearchRange = ComponentParse.getInteger((JSpinner)this.gramSearchRange);
        String[][] commonGrams = new String[][]{this.BI_GRAM[0], this.TRI_GRAM[this.trigramSets.getSelectedIndex()]};
        switch (method) {
            case CALCULATED: {
                for (int size = this.sizeRange[0]; size <= this.sizeRange[1]; ++size) {
                    int sizeF = size;
                    Map chars = CharacterCount.getCount((CharSequence)text, (int)size, (int)size, (boolean)false);
                    ArrayList sorted = new ArrayList(chars.keySet());
                    Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER.thenComparingInt(key -> (Integer)chars.get(key)).reversed());
                    this.output((IDecryptionTracker)tracker, "" + chars.size(), new Object[0]);
                    int[][] pickPattern = this.generatePickPattern(size, Math.min(gramSearchRange, sorted.size()));
                    if (size == 2) {
                        for (int i = 0; i < pickPattern.length; ++i) {
                            Object[] matrixData = new Integer[]{};
                            for (int k = 0; k < size; ++k) {
                                Integer[][] equations = new Integer[size][size + 1];
                                for (int l = 0; l < size; ++l) {
                                    equations[l] = this.createEquationFrom(commonGrams[size - 2][l], (String)sorted.get(pickPattern[i][l]), k);
                                }
                                Object[] solution = SimultaneousEquations.solve((Integer[][])equations, (int)26);
                                matrixData = (Integer[])ArrayUtil.concatGeneric((Object[])matrixData, (Object[])solution);
                            }
                            this.decryptAndUpdate((IDecryptionTracker)tracker, new Matrix((Integer[])matrixData, size, size));
                        }
                        continue;
                    }
                    if (size != 3) continue;
                    try {
                        FileReader.read((String)"/resources/commontrigrampairings.txt", line -> {
                            String[] str = StringUtils.splitInto((String)line, (int)3);
                            for (int i = 0; i < pickPattern.length; ++i) {
                                Object[] matrixData = new Integer[]{};
                                for (int k = 0; k < sizeF; ++k) {
                                    Integer[][] equations = new Integer[sizeF][sizeF + 1];
                                    for (int l = 0; l < sizeF; ++l) {
                                        equations[l] = this.createEquationFrom(str[l], (String)sorted.get(pickPattern[i][l]), k);
                                    }
                                    Object[] solution = SimultaneousEquations.solve((Integer[][])equations, (int)26);
                                    matrixData = (Integer[])ArrayUtil.concatGeneric((Object[])matrixData, (Object[])solution);
                                }
                                this.decryptAndUpdate((IDecryptionTracker)tracker, new Matrix((Integer[])matrixData, sizeF, sizeF));
                            }
                        });
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return tracker;
            }
            case PERIODIC_KEY: {
                for (int size = this.sizeRange[0]; size <= this.sizeRange[1]; ++size) {
                    tracker.resultList.clear();
                    if (tracker.getCipherText().length() % size != 0) {
                        this.output((IDecryptionTracker)tracker, "Matrix size of %d is not possible, length of text is not a multiple.", new Object[]{size});
                        continue;
                    }
                    tracker.size = size;
                    tracker.lengthSub = tracker.getCipherText().length() / size;
                    KeyIterator.iterateIntegerArray(row -> this.iterateMatrixRows(tracker, (Integer[])row), (int)size, (int)26, (boolean)true);
                    tracker.resultList.sort();
                    if (tracker.resultList.size() < size) {
                        this.output((IDecryptionTracker)tracker, "Did not find enought key columns that produces good characters %d/%d", new Object[]{tracker.resultList.size(), size});
                        continue;
                    }
                    KeyIterator.iterateObject(row -> this.iteratePossibleRows(tracker, (HillSection[])row), (int)size, (Object[])((HillSection[])tracker.resultList.toArray((Object[])new HillSection[0])));
                }
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public void decryptAndUpdate(IDecryptionTracker tracker, Matrix key) {
        try {
            super.decryptAndUpdate(tracker, (Object)key);
        }
        catch (MatrixNoInverse | MatrixNotSquareException e) {
            return;
        }
    }

    public int[][] generatePickPattern(int size, int times) {
        int[][] patterns = new int[(int)Math.pow(times, size)][size];
        int count = 0;
        if (size == 2) {
            for (int i = 0; i < times; ++i) {
                for (int j = 0; j < times; ++j) {
                    if (i == j) continue;
                    patterns[count++] = new int[]{i, j};
                }
            }
            return patterns;
        }
        if (size == 3) {
            for (int i = 0; i < times; ++i) {
                for (int j = 0; j < times; ++j) {
                    for (int k = 0; k < times; ++k) {
                        if (i == j || i == k || j == k) continue;
                        patterns[count++] = new int[]{i, j, k};
                    }
                }
            }
            return patterns;
        }
        return new int[0][0];
    }

    public boolean iterateMatrixRows(HillTracker tracker, Integer[] row) {
        if (MathUtil.allDivisibleBy((Integer[])row, (int)0, (int)tracker.size, (int[])new int[]{2, 13})) {
            return true;
        }
        char[] decrypted = new char[tracker.lengthSub];
        for (int i = 0; i < tracker.getCipherText().length(); i += tracker.size) {
            int total = 0;
            for (int s = 0; s < tracker.size; ++s) {
                total += row[s] * (tracker.getCipherText().charAt(i + s) - 65);
            }
            decrypted[i / tracker.size] = (char)(total % 26 + 65);
        }
        double score = ChiSquared.calculate((char[])decrypted, (ILanguage)tracker.getLanguage());
        if (tracker.resultList.add((Result)new HillSection(score, decrypted, Arrays.copyOf(row, row.length))) && score < 80.0) {
            this.output((IDecryptionTracker)tracker, "%s, %f, %s", new Object[]{Arrays.toString((Object[])row), score, new String(decrypted)});
        }
        return true;
    }

    public boolean iteratePossibleRows(HillTracker tracker, HillSection[] data) {
        Integer[] inverseData = new Integer[tracker.size * tracker.size];
        for (int s = 0; s < tracker.size; ++s) {
            HillSection hillResult = data[s];
            for (int n = 0; n < tracker.size; ++n) {
                inverseData[s * tracker.size + n] = hillResult.inverseCol[n];
            }
        }
        Matrix inverseMatrix = new Matrix(inverseData, tracker.size);
        if (!inverseMatrix.hasInverseMod(26)) {
            return true;
        }
        for (int s = 0; s < tracker.size; ++s) {
            HillSection hillResult = data[s];
            for (int i = 0; i < tracker.lengthSub; ++i) {
                tracker.getHolder()[i * tracker.size + s] = hillResult.decrypted[i];
            }
        }
        tracker.setLastSolution(new Solution(tracker.getHolder(), tracker.getLanguage()));
        this.updateIfBetterThanBest((IDecryptionTracker)tracker, tracker.getLastSolution(), () -> inverseMatrix.inverseMod(26));
        return true;
    }

    public Integer[] createEquationFrom(String plainText, String cipherText, int index) {
        Integer[] equation = new Integer[plainText.length() + 1];
        for (int i = 0; i < equation.length - 1; ++i) {
            equation[i] = plainText.charAt(i) - 65;
        }
        equation[equation.length - 1] = cipherText.charAt(index) - 65;
        return equation;
    }

    public static class HillSection
    extends ResultPositive {
        public char[] decrypted;
        public Integer[] inverseCol;

        public HillSection(double score, char[] decrypted, Integer[] inverseCol) {
            super(score);
            this.decrypted = decrypted;
            this.inverseCol = inverseCol;
        }
    }

    public class HillTracker
    extends DecryptionTracker {
        private int size;
        private int lengthSub;
        private DynamicResultList<HillSection> resultList;

        public HillTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.resultList = new DynamicResultList(8);
        }
    }
}

