/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.route;

import com.alexbarter.ciphertool.ciphers.route.Routes;
import com.alexbarter.lib.Pair;
import java.util.HashMap;

public abstract class RouteCipherType {
    private String description;
    public HashMap<Pair<Integer, Integer>, int[]> cache = new HashMap();

    public RouteCipherType() {
        this("No description");
    }

    public RouteCipherType(String description) {
        this(description, true);
    }

    public RouteCipherType(String description, Object ... obj) {
        this(String.format(description, obj));
    }

    public RouteCipherType(String description, boolean add) {
        this.description = description;
        if (add) {
            Routes.ROUTES.add(this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean canCache() {
        return true;
    }

    public final int[] getPattern(int width, int height, int totalSize) {
        if (!this.canCache()) {
            return this.createPattern(width, height, totalSize);
        }
        Pair key = new Pair((Object)width, (Object)height);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        int[] grid = this.createPattern(width, height, totalSize);
        this.cache.put((Pair<Integer, Integer>)key, grid);
        return grid;
    }

    public abstract int[] createPattern(int var1, int var2, int var3);
}

