/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.util.VigenereType;
import javax.annotation.Nullable;

public class VigenereCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    private VigenereType type;

    public VigenereCipher(VigenereType type) {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
        this.type = type;
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder secondKey) {
        return secondKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, String key) {
        char[] cipherText = new char[plainText.length()];
        int period = key.length();
        for (int index = 0; index < plainText.length(); ++index) {
            cipherText[index] = this.type.encode(plainText.charAt(index), key.charAt(index % period));
        }
        return new String(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int period = key.length();
        for (int index = 0; index < cipherText.length(); ++index) {
            plainText[index] = this.type.decode(cipherText.charAt(index), key.charAt(index % period));
        }
        return plainText;
    }
}

