/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.settings.SettingsCache;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.IKeySearchAttack;
import com.alexbarter.ciphertool.ciphers.ProgressiveCipher;

public class ProgressiveKeyAttack
extends CipherAttack<TriKey<String, Integer, Integer>, ProgressiveCipher>
implements IKeySearchAttack<TriKey<String, Integer, Integer>> {
    private int[] periodRange = new int[]{2, 15};
    private TriKey<String, Integer, Integer> periodicKey = TriKey.empty();

    public ProgressiveKeyAttack(ProgressiveCipher cipher, String displayName) {
        super((ICipher)cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)15, (int)2, (int)100, (int)1, (values, cipher2) -> {
            this.periodRange = values;
            cipher2.limitDomainForFirstKey(builder -> builder.setRange(values));
        })});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"prog_period", (int)1, (int)30, (int)1, (int)100, (int)1, (values, cipher2) -> cipher2.setSecondKeyDomain(builder -> builder.setRange(values)))});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"prog_key", (int)1, (int)25, (int)1, (int)100, (int)1, (values, cipher2) -> cipher2.setThirdKeyDomain(builder -> builder.setRange(values)))});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case PERIODIC_KEY: {
                app.getProgress().setIndeterminate(true);
                DecryptionTracker tracker = new DecryptionTracker(text, app);
                ((ProgressiveCipher)this.getCipher()).getSecondKeyType().iterateKeys(progPeriod -> {
                    ((ProgressiveCipher)this.getCipher()).getThirdKeyType().iterateKeys(progKey -> {
                        this.periodicKey.setSecond(progPeriod);
                        this.periodicKey.setThird(progKey);
                        for (int period = this.periodRange[0]; period <= this.periodRange[1]; ++period) {
                            this.tryKeySearch((IDecryptionTracker)tracker, period);
                        }
                        return true;
                    });
                    return true;
                });
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public TriKey<String, Integer, Integer> useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        if (((Boolean)SettingsCache.useParallel.get()).booleanValue()) {
            return this.periodicKey.clone().setFirst((Object)periodicPart);
        }
        return this.periodicKey.setFirst((Object)periodicPart);
    }
}

