/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.FullStringKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerGenKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import javax.annotation.Nullable;

public class TrifidCipher
extends BiKeyCipher<String, Integer, FullStringKeyType.Builder, IntegerGenKeyType.Builder> {
    public TrifidCipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ#"), (IKeyType.IKeyBuilder)IntegerGenKeyType.builder().setRange(0, 5000).addFilter(i -> i != 1));
    }

    public IntegerGenKeyType.Builder limitDomainForSecondKey(IntegerGenKeyType.Builder secondKey) {
        return secondKey.setRange(0, 15);
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, Integer> key) {
        int period = (Integer)key.getSecondKey();
        if (period == 0) {
            period = plainText.length();
        }
        int[] numberText = new int[plainText.length() * 3];
        for (int i = 0; i < plainText.length(); ++i) {
            char a = plainText.charAt(i);
            int index = ((String)key.getFirstKey()).indexOf(a);
            int tableNo = index / 9 + 1;
            int rowNo = index / 3 % 3 + 1;
            int colNo = index % 3 + 1;
            int blockBase = i / period * (period * 3) + i % period;
            int min = Math.min(period, plainText.length() - i / period * period);
            numberText[blockBase] = tableNo;
            numberText[blockBase + min] = rowNo;
            numberText[blockBase + min * 2] = colNo;
        }
        Character[] cipherText = new Character[plainText.length()];
        int index = 0;
        for (int i = 0; i < numberText.length; i += 3) {
            int a = numberText[i] - 1;
            int b = numberText[i + 1] - 1;
            int c = numberText[i + 2] - 1;
            cipherText[index++] = Character.valueOf(((String)key.getFirstKey()).charAt(a * 9 + b * 3 + c));
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, Integer> key) {
        int period = (Integer)key.getSecondKey();
        byte[] numberText = new byte[cipherText.length() * 3];
        if (period == 0) {
            period = cipherText.length();
        }
        int blocks = (int)Math.ceil((double)cipherText.length() / (double)period);
        int indexNo = 0;
        int index = 0;
        for (int b = 0; b < blocks; ++b) {
            int f;
            int chPass = b * period;
            int noPass = chPass * 3;
            int min = Math.min(period, cipherText.length() - chPass);
            for (f = 0; f < min; ++f) {
                int index1 = ((String)key.getFirstKey()).indexOf(cipherText.charAt(chPass + f));
                numberText[indexNo++] = (byte)(index1 / 9);
                numberText[indexNo++] = (byte)(index1 / 3 % 3);
                numberText[indexNo++] = (byte)(index1 % 3);
            }
            for (f = 0; f < min; ++f) {
                plainText[index++] = ((String)key.getFirstKey()).charAt(numberText[noPass + f] * 9 + numberText[noPass + min + f] * 3 + numberText[noPass + min * 2 + f]);
            }
        }
        return plainText;
    }
}

