/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import java.util.Map;
import javax.annotation.Nullable;

public class PlayfairCipher
extends UniKeyCipher<String, SquareStringKeyType.Builder> {
    private int size;

    public PlayfairCipher() {
        this("ABCDEFGHIKLMNOPQRSTUVWXYZ");
    }

    public PlayfairCipher(CharSequence alphabet) {
        this(alphabet, (int)Math.sqrt(alphabet.length()));
    }

    private PlayfairCipher(CharSequence alphabet, int size) {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet(alphabet).setDim(size, size));
        this.size = size;
    }

    public CharSequence normaliseText(CharSequence plainText, String key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        int i = 0;
        while (plainText.length() - i >= 2) {
            char a = plainText.charAt(i);
            char b = plainText.charAt(i + 1);
            if (a == 'J') {
                a = 'I';
            }
            if (b == 'J') {
                b = 'I';
            }
            builder.append(a);
            if (a == b) {
                builder.append(a == 'X' ? (char)'Q' : 'X');
                --i;
            } else {
                builder.append(b);
            }
            i += 2;
        }
        if (i < plainText.length()) {
            char c = plainText.charAt(plainText.length() - 1);
            if (c == 'J') {
                c = 'I';
            }
            builder.append(c);
        }
        if (builder.length() % 2 == 1) {
            char f = builder.charAt(builder.length() - 1);
            builder.append(f == 'X' ? (char)'Q' : 'X');
        }
        return builder.toString();
    }

    public CharSequence encode(CharSequence plainText, String key) {
        Character[] cipherText = new Character[plainText.length()];
        for (int i = 0; i < plainText.length(); i += 2) {
            char d;
            char c;
            char a = plainText.charAt(i);
            char b = plainText.charAt(i + 1);
            int i1 = key.indexOf(a);
            int i2 = key.indexOf(b);
            int row1 = (int)Math.floor(i1 / this.size);
            int col1 = i1 % this.size;
            int row2 = (int)Math.floor(i2 / this.size);
            int col2 = i2 % this.size;
            if (row1 == row2) {
                c = key.charAt(row1 * this.size + (col1 + 1) % this.size);
                d = key.charAt(row2 * this.size + (col2 + 1) % this.size);
            } else if (col1 == col2) {
                c = key.charAt((row1 + 1) % this.size * this.size + col1);
                d = key.charAt((row2 + 1) % this.size * this.size + col2);
            } else {
                c = key.charAt(row1 * this.size + col2);
                d = key.charAt(row2 * this.size + col1);
            }
            cipherText[i] = Character.valueOf(c);
            cipherText[i + 1] = Character.valueOf(d);
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        Map keyIndex = CipherUtils.createCharacterIndexMapping((CharSequence)key);
        for (int i = 0; i < cipherText.length(); i += 2) {
            int i1 = (Integer)keyIndex.get(Character.valueOf(cipherText.charAt(i)));
            int i2 = (Integer)keyIndex.get(Character.valueOf(cipherText.charAt(i + 1)));
            int row1 = i1 / this.size;
            int col1 = i1 % this.size;
            int row2 = i2 / this.size;
            int col2 = i2 % this.size;
            if (row1 == row2) {
                plainText[i] = key.charAt(row1 * this.size + (col1 + this.size - 1) % this.size);
                plainText[i + 1] = key.charAt(row2 * this.size + (col2 + this.size - 1) % this.size);
                continue;
            }
            if (col1 == col2) {
                plainText[i] = key.charAt((row1 + this.size - 1) % this.size * this.size + col1);
                plainText[i + 1] = key.charAt((row2 + this.size - 1) % this.size * this.size + col2);
                continue;
            }
            plainText[i] = key.charAt(row1 * this.size + col2);
            plainText[i + 1] = key.charAt(row2 * this.size + col1);
        }
        return plainText;
    }
}

