/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.EnumKeyType;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.util.ReadMode;
import javax.annotation.Nullable;

public class NihilistTranspositionCipher
extends BiKeyCipher<Integer[], ReadMode, OrderedIntegerKeyType.Builder, EnumKeyType.Builder<ReadMode>> {
    public NihilistTranspositionCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)EnumKeyType.builder(ReadMode.class).setUniverse((Enum[])ReadMode.values()));
    }

    public IKeyType.IKeyBuilder<Integer[]> limitDomainForFirstKey(OrderedIntegerKeyType.Builder firstKey) {
        return firstKey.setRange(2, 7);
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<Integer[], ReadMode> key) {
        int blockSize = ((Integer[])key.getFirstKey()).length * ((Integer[])key.getFirstKey()).length;
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer[], ReadMode> key) {
        int blockSize = ((Integer[])key.getFirstKey()).length * ((Integer[])key.getFirstKey()).length;
        if (plainText.length() != blockSize) {
            StringBuilder builder = new StringBuilder(plainText.length());
            for (int i = 0; i < plainText.length(); i += blockSize) {
                builder.append(NihilistTranspositionCipher.encodeSection(plainText, i, key));
            }
            return builder;
        }
        return NihilistTranspositionCipher.encodeSection(plainText, 0, key);
    }

    public static CharSequence encodeSection(CharSequence plainText, int start, BiKey<Integer[], ReadMode> key) {
        char[] cipherText = new char[((Integer[])key.getFirstKey()).length * ((Integer[])key.getFirstKey()).length];
        int index = 0;
        switch ((ReadMode)((Object)key.getSecondKey())) {
            case ACROSS: {
                for (int row = 0; row < ((Integer[])key.getFirstKey()).length; ++row) {
                    for (int column = 0; column < ((Integer[])key.getFirstKey()).length; ++column) {
                        cipherText[index++] = plainText.charAt(start + ((Integer[])key.getFirstKey())[row] * ((Integer[])key.getFirstKey()).length + ((Integer[])key.getFirstKey())[column]);
                    }
                }
                break;
            }
            case DOWN: {
                for (int column = 0; column < ((Integer[])key.getFirstKey()).length; ++column) {
                    for (int row = 0; row < ((Integer[])key.getFirstKey()).length; ++row) {
                        cipherText[index++] = plainText.charAt(start + ((Integer[])key.getFirstKey())[row] * ((Integer[])key.getFirstKey()).length + ((Integer[])key.getFirstKey())[column]);
                    }
                }
                break;
            }
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer[], ReadMode> key) {
        int columns = ((Integer[])key.getFirstKey()).length;
        int[] reversedOrder = new int[columns];
        for (int i = 0; i < columns; ++i) {
            reversedOrder[((Integer[])key.getFirstKey())[i].intValue()] = i;
        }
        int blockSize = ((Integer[])key.getFirstKey()).length * ((Integer[])key.getFirstKey()).length;
        if (cipherText.length() != blockSize) {
            for (int i = 0; i < cipherText.length(); i += blockSize) {
                plainText = NihilistTranspositionCipher.decodeSection(cipherText, plainText, i, key, reversedOrder);
            }
        } else {
            plainText = NihilistTranspositionCipher.decodeSection(cipherText, plainText, 0, key, reversedOrder);
        }
        return plainText;
    }

    public static char[] decodeSection(CharSequence cipherText, char[] plainText, int start, BiKey<Integer[], ReadMode> key, int[] reversedOrder) {
        int index = start;
        switch ((ReadMode)((Object)key.getSecondKey())) {
            case ACROSS: {
                for (int row = 0; row < ((Integer[])key.getFirstKey()).length; ++row) {
                    for (int column = 0; column < ((Integer[])key.getFirstKey()).length; ++column) {
                        plainText[index++] = cipherText.charAt(start + reversedOrder[row] * ((Integer[])key.getFirstKey()).length + reversedOrder[column]);
                    }
                }
                break;
            }
            case DOWN: {
                for (int column = 0; column < ((Integer[])key.getFirstKey()).length; ++column) {
                    for (int row = 0; row < ((Integer[])key.getFirstKey()).length; ++row) {
                        plainText[index++] = cipherText.charAt(start + reversedOrder[row] * ((Integer[])key.getFirstKey()).length + reversedOrder[column]);
                    }
                }
                break;
            }
        }
        return plainText;
    }
}

