/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import com.alexbarter.lib.util.ArrayUtil;
import javax.annotation.Nullable;

public class HuttonCipher
extends BiKeyCipher<String, String, VariableStringKeyType.Builder, VariableStringKeyType.Builder> {
    public HuttonCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXY").setRange(1, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(1, Integer.MAX_VALUE));
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(1, 7);
    }

    public VariableStringKeyType.Builder limitDomainForSecondKey(VariableStringKeyType.Builder secondKey) {
        return secondKey.setRange(1, 7);
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, String> key) {
        char[] secondKey = new char[26];
        int d = 0;
        for (d = 0; d < ((String)key.getSecondKey()).length(); ++d) {
            secondKey[d] = ((String)key.getSecondKey()).charAt(d);
        }
        for (char alpha = 'A'; alpha <= 'Z'; alpha = (char)(alpha + '\u0001')) {
            if (ArrayUtil.contains((char[])secondKey, (int)0, (int)d, (char)alpha)) continue;
            secondKey[d++] = alpha;
        }
        Character[] cipherText = new Character[plainText.length()];
        for (int i = 0; i < plainText.length(); ++i) {
            int keyIndex = ArrayUtil.indexOf((char[])secondKey, (char)plainText.charAt(i));
            int newKeyIndex = (keyIndex + (((String)key.getFirstKey()).charAt(i % ((String)key.getFirstKey()).length()) - 65 + 1)) % secondKey.length;
            cipherText[i] = Character.valueOf(secondKey[newKeyIndex]);
            secondKey[keyIndex] = cipherText[i].charValue();
            secondKey[newKeyIndex] = plainText.charAt(i);
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, String> key) {
        char[] secondKey = new char[26];
        int d = 0;
        for (d = 0; d < ((String)key.getSecondKey()).length(); ++d) {
            secondKey[d] = ((String)key.getSecondKey()).charAt(d);
        }
        for (char alpha = 'A'; alpha <= 'Z'; alpha = (char)(alpha + '\u0001')) {
            if (ArrayUtil.contains((char[])secondKey, (int)0, (int)d, (char)alpha)) continue;
            secondKey[d++] = alpha;
        }
        for (int i = 0; i < cipherText.length(); ++i) {
            int keyIndex = ArrayUtil.indexOf((char[])secondKey, (char)cipherText.charAt(i));
            int newKeyIndex = (keyIndex - (((String)key.getFirstKey()).charAt(i % ((String)key.getFirstKey()).length()) - 65 + 1) + secondKey.length) % secondKey.length;
            plainText[i] = secondKey[newKeyIndex];
            secondKey[keyIndex] = plainText[i];
            secondKey[newKeyIndex] = cipherText.charAt(i);
        }
        return plainText;
    }
}

