/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.key.KeyGeneration;
import com.alexbarter.ciphertool.base.key.types.SquareMatrixKeyType;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import java.math.BigInteger;
import java.util.function.Function;
import javax.annotation.Nullable;

public class HillExtendedCipher
implements ICipher<BiKey<Matrix, Matrix>> {
    private final int mod;
    protected final SquareMatrixKeyType firstType;
    private SquareMatrixKeyType firstTypeLimit;
    private final SquareMatrixKeyType.Builder firstKeyBuilder;

    public HillExtendedCipher() {
        this(26);
    }

    public HillExtendedCipher(int mod) {
        SquareMatrixKeyType.Builder firstKey = SquareMatrixKeyType.builder().setRange(1, Integer.MAX_VALUE).setMod(mod);
        this.firstType = firstKey.create();
        this.firstTypeLimit = firstKey.setRange(2, 4).create();
        this.firstKeyBuilder = firstKey;
        this.mod = mod;
    }

    public boolean isValid(BiKey<Matrix, Matrix> key) {
        return this.firstType.isValid((Matrix)key.getFirstKey()) && ((Matrix)key.getSecondKey()).rows == ((Matrix)key.getFirstKey()).size();
    }

    public BiKey<Matrix, Matrix> randomiseKey() {
        Matrix matrix = this.firstTypeLimit.randomise();
        return BiKey.of((Object)matrix, (Object)KeyGeneration.createMatrix((int)matrix.size(), (int)1, (int)this.mod));
    }

    public boolean iterateKeys(Function<BiKey<Matrix, Matrix>, Boolean> consumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BiKey<Matrix, Matrix> alterKey(BiKey<Matrix, Matrix> key, double temp, int count) {
        return key;
    }

    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ONE;
        return total;
    }

    public String prettifyKey(BiKey<Matrix, Matrix> key) {
        return String.join((CharSequence)" ", this.firstType.prettifyKey((Matrix)key.getFirstKey()), String.valueOf(key.getSecondKey()));
    }

    public void limitDomainForFirstKey(Function<SquareMatrixKeyType.Builder, SquareMatrixKeyType.Builder> firstKeyFunc) {
        this.firstTypeLimit = firstKeyFunc.apply(this.firstKeyBuilder).create();
    }

    public SquareMatrixKeyType getFirstKeyType() {
        return this.firstTypeLimit;
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<Matrix, Matrix> key) {
        int blockSize = ((Matrix)key.getFirstKey()).size();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Matrix, Matrix> key) {
        char[] cipherText = new char[plainText.length()];
        int size = ((Matrix)key.getFirstKey()).size();
        for (int i = 0; i < plainText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = plainText.charAt(i + j) - 65;
            }
            Matrix plainMatrix = new Matrix(let, size, 1);
            Matrix cipherMatrix = ((Matrix)key.getFirstKey()).multiply(plainMatrix).add((Matrix)key.getSecondKey()).modular(26);
            for (int j = 0; j < size; ++j) {
                cipherText[i + j] = (char)(cipherMatrix.data[j] + 65);
            }
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Matrix, Matrix> key) {
        return this.decodeUsingInverse(cipherText, plainText, ((Matrix)key.getFirstKey()).inverseMod(26), (Matrix)key.getSecondKey());
    }

    public char[] decodeUsingInverse(CharSequence cipherText, char[] plainText, Matrix inverseKey, Matrix secondKey) {
        int size = inverseKey.size();
        for (int i = 0; i < cipherText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = cipherText.charAt(i + j) - 65;
            }
            Matrix cipherMatrix = new Matrix(let, size, 1);
            Matrix plainMatrix = inverseKey.multiply(cipherMatrix.subtract(secondKey)).modular(26);
            for (int j = 0; j < size; ++j) {
                plainText[i + j] = (char)(plainMatrix.data[j] + 65);
            }
        }
        return plainText;
    }
}

