/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.base.key.KeyIterator;
import tools.cipher.base.key.KeyManipulation;

public class OrderedIntegerKeyType
implements IRangedKeyType<Integer[]> {
    private final int min;
    private final int max;
    private final Optional<Integer> range;
    private final boolean repeats;
    private final Function<Integer[], String> displayFunc;

    private OrderedIntegerKeyType(int min, int max, Optional<Integer> range, boolean repeats, Function<Integer[], String> displayFunc) {
        this.min = min;
        this.max = max;
        this.range = range;
        this.repeats = repeats;
        this.displayFunc = displayFunc;
    }

    @Override
    public Integer[] randomise() {
        BiFunction<Integer, Integer, Integer[]> func = this.repeats ? KeyGeneration::createRepeatingShortOrderKey : KeyGeneration::createShortOrderKey;
        int length = RandomUtil.pickRandomInt((int)this.min, (int)this.max);
        return func.apply(this.range.orElse(length), length);
    }

    @Override
    public boolean isValid(Integer[] key) {
        for (int i = 0; i < key.length; ++i) {
            if (key[i] >= this.range.orElse(key.length) || key[i] < 0) {
                return false;
            }
            if (this.repeats || i >= key.length - 1 || !ArrayUtil.contains((Object[])key, (int)(i + 1), (int)key.length, (Object)key[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<Integer[], Boolean> consumer) {
        for (int length = this.min; length <= this.max; ++length) {
            if (KeyIterator.iterateIntegerArray(consumer, this.range.orElse(length), length, this.repeats)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer[] alterKey(Integer[] key) {
        return KeyManipulation.modifyOrder(key);
    }

    @Override
    public String prettifyKey(Integer[] key) {
        return this.displayFunc == null ? Arrays.toString((Object[])key) : this.displayFunc.apply(key);
    }

    @Override
    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ZERO;
        for (int length = this.min; length <= this.max; ++length) {
            total = this.repeats ? total.add(BigInteger.valueOf(this.range.orElse(length).intValue()).pow(length)) : total.add(MathUtil.factorialLength((BigInteger)BigInteger.valueOf(this.range.orElse(length).intValue()), (BigInteger)BigInteger.valueOf(length)));
        }
        return total;
    }

    @Override
    public Integer[] parse(String input) throws ParseException {
        if (input.startsWith("[") && input.endsWith("]")) {
            int offset = 1;
            String[] elements = input.substring(1, input.length() - 1).split(",");
            Integer[] key = new Integer[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                try {
                    key[i] = Integer.valueOf(elements[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseException(input, offset);
                }
                finally {
                    offset += elements[i].length() + 1;
                }
            }
            return key;
        }
        throw new ParseException(input, 0);
    }

    @Override
    public String getHelp() {
        return "array";
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<Integer[]> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();
        private Optional<Integer> entryRange = Optional.empty();
        private boolean repeats = false;
        private Function<Integer[], String> displayFunc;

        private Builder() {
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public Builder setEntryRange(int range) {
            this.entryRange = Optional.of(range);
            return this;
        }

        public Builder setRepeats() {
            this.repeats = true;
            return this;
        }

        public Builder setDisplay(Function<Integer[], String> displayFunc) {
            this.displayFunc = displayFunc;
            return this;
        }

        public OrderedIntegerKeyType create() {
            OrderedIntegerKeyType handler = new OrderedIntegerKeyType(this.min.orElse(2), this.max.orElse(6), this.entryRange, this.repeats, this.displayFunc);
            return handler;
        }
    }
}

