/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.format;

import java.text.ParseException;
import tools.cipher.base.format.IParseFormat;
import tools.cipher.base.interfaces.IFormat;

public class CaseFormat
implements IFormat {
    private Type charCase;
    private static final CaseFormat UPPER_FORMAT = new CaseFormat(Type.UPPER);
    private static final CaseFormat LOWER_FORMAT = new CaseFormat(Type.LOWER);
    private static final CaseFormat START_FORMAT = new CaseFormat(Type.START);
    public static final IParseFormat PARSE = (text, args) -> {
        switch (args) {
            case "upper": {
                return UPPER_FORMAT;
            }
            case "lower": {
                return LOWER_FORMAT;
            }
            case "start": {
                return START_FORMAT;
            }
        }
        throw new ParseException("Unrecognised case type - " + args, 0);
    };

    public CaseFormat(Type caseIn) {
        this.charCase = caseIn;
    }

    @Override
    public CharSequence format(CharSequence text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            builder.append(this.charCase.apply(text, text.charAt(i), i));
        }
        return builder;
    }

    public static enum Type {
        UPPER((t, c, i) -> Character.toUpperCase(c)),
        LOWER((t, c, i) -> Character.toLowerCase(c)),
        START((t, c, i) -> (i == 0 || t.charAt(i - 1) == ' ' ? UPPER : LOWER).apply(t, c, i));

        private CaseFormatLogic func;

        private Type(CaseFormatLogic func) {
            this.func = func;
        }

        public char apply(CharSequence text, char ch, int index) {
            return this.func.format(text, ch, index);
        }
    }

    @FunctionalInterface
    public static interface CaseFormatLogic {
        public char format(CharSequence var1, char var2, int var3);
    }
}

