/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.ciphers;

import java.math.BigInteger;
import java.util.function.Function;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.lib.characters.CharArrayWrapper;

public class CipherChain<K, H, C extends ICipher<K>, S extends ICipher<H>>
implements ICipher<BiKey<K, H>> {
    private C cipher1;
    private S cipher2;

    private CipherChain(C cipher1, S cipher2) {
        this.cipher1 = cipher1;
        this.cipher2 = cipher2;
    }

    public static <K, H, C extends ICipher<K>, S extends ICipher<H>> CipherChain<K, H, C, S> chain(C cipher1, S cipher2) {
        return new CipherChain<K, H, C, S>(cipher1, cipher2);
    }

    @Override
    public CharSequence encode(CharSequence plainText, BiKey<K, H> key) {
        return this.cipher2.encode(this.cipher1.encode(plainText, key.getFirstKey()), key.getSecondKey());
    }

    @Override
    public char[] decodeEfficiently(CharSequence cipherText, char[] plainText, BiKey<K, H> key) {
        return this.cipher1.decodeEfficiently((CharSequence)new CharArrayWrapper(this.cipher2.decodeEfficiently(cipherText, new char[cipherText.length()], key.getSecondKey())), plainText, key.getFirstKey());
    }

    @Override
    public BiKey<K, H> randomiseKey() {
        return BiKey.of(this.cipher1.randomiseKey(), this.cipher2.randomiseKey());
    }

    @Override
    public boolean iterateKeys(Function<BiKey<K, H>, Boolean> consumer) {
        return this.cipher1.iterateKeys((K k) -> this.cipher2.iterateKeys((K h) -> (Boolean)consumer.apply(BiKey.of(k, h))));
    }

    @Override
    public boolean isValid(BiKey<K, H> key) {
        return this.cipher1.isValid(key.getFirstKey()) && this.cipher2.isValid(key.getSecondKey());
    }

    @Override
    public BigInteger getNumOfKeys() {
        return this.cipher1.getNumOfKeys().multiply(this.cipher2.getNumOfKeys());
    }
}

